/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroArchivoEstadoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroArchivoEstadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroDetalleResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroListadoResponse;
import ar.com.sdd.patagoniaapi.io.LoginRequest;
import ar.com.sdd.patagoniaapi.io.LoginResponse;
import ar.com.sdd.patagoniaapi.model.Documento;
import ar.com.sdd.patagoniaapi.model.Empresa;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import ar.com.sdd.patagoniaapi.model.Respuesta;
import ar.com.sdd.patagoniaapi.model.Token;
import ar.com.sdd.patagoniaapi.model.Usuario;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatagoniaApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(PatagoniaApiConnector.class);
    private final RestConnector restConnector;
    private final String xApplicationId;
    private final String usuarioAlias;
    private final String documentoTipo;
    private final String documentoNumero;
    private final String adherente;
    private final String convenio;
    private final String docProd;
    private boolean doingLogin;
    private String accessToken;
    private static final String channel = "PT";
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ERROR = "ERROR";

    public PatagoniaApiConnector(PatagoniaApiConnectorContext context) {
        this.usuarioAlias = context.getUsuarioAlias();
        this.documentoTipo = context.getDocumentoTipo();
        this.documentoNumero = context.getDocumentoNumero();
        this.xApplicationId = context.getXApplicationKey();
        this.adherente = context.getAdherente();
        this.convenio = context.getConvenio();
        this.docProd = context.getDocProd();
        log.debug("Creando PatagoniaApiConnector con " + context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public EmpresaCobroArchivoEstadoResponse publicarDeuda(String fileName, String fileInBase64) throws RestConnectorException {
        Respuesta respuesta;
        log.debug("[uploadFile] Por hacer upload del archivo");
        LoginResponse loginResponse = this.generateAccessToken();
        String uriOperador = loginResponse.getUsuario().getUriOperador();
        String uriSFB = uriOperador.split(";")[1];
        Optional<String> userId = Arrays.stream(uriSFB.split("#")).filter(s -> s.startsWith("B2B")).findFirst();
        if (userId.isEmpty()) {
            throw new RuntimeException("No se pudo obtener el userId del LoginResponse.Usuario.UriOperador [" + uriOperador + "]");
        }
        EmpresaArchivoRequest empresaArchivoRequest = new EmpresaArchivoRequest();
        empresaArchivoRequest.setToken(this.generateUploadToken());
        empresaArchivoRequest.setUserId(userId.get());
        empresaArchivoRequest.setFileName(fileName);
        empresaArchivoRequest.setFile(fileInBase64);
        EmpresaArchivoResponse empresaArchivoResponse = (EmpresaArchivoResponse)this.restConnector.genericPost((Object)empresaArchivoRequest, EmpresaArchivoResponse.class, "/archivo", "application/json", "application/x-www-form-urlencoded");
        log.debug("[uploadFile] Response: " + empresaArchivoResponse);
        if (empresaArchivoResponse != null && empresaArchivoResponse.getRespuesta() != null && (respuesta = empresaArchivoResponse.getRespuesta()).getCodigo().equals(STATUS_OK)) {
            return this.confirmarOperacion(empresaArchivoRequest.getToken(), fileName.substring(0, 2));
        }
        return null;
    }

    public EmpresaCobroArchivoEstadoResponse confirmarOperacion(String token, String tipoArchivo) throws RestConnectorException {
        log.debug("[confirmarOperacion] Por confirmar procesamiento del archivo que acabamos de subir");
        EmpresaCobroArchivoEstadoRequest empresaCobroArchivoEstadoRequest = new EmpresaCobroArchivoEstadoRequest();
        empresaCobroArchivoEstadoRequest.setToken(token);
        String subconvenio = "1";
        String confirmPath = "/cobro/archivo/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/estado/tipo-arch/" + tipoArchivo + "/doc-tp/" + this.documentoTipo + "/docNum/" + this.documentoNumero + "/ch/PT";
        return (EmpresaCobroArchivoEstadoResponse)this.restConnector.genericPost((Object)empresaCobroArchivoEstadoRequest, EmpresaCobroArchivoEstadoResponse.class, ErrorResponse.class, confirmPath);
    }

    public void consultaConvenioPorAdherente() {
    }

    public EmpresaCobroListadoResponse consultarPosicionIntegralDeCobros(Date fromDate, Date toDate) throws RestConnectorException {
        this.generateAccessToken();
        int urlParamsSep = 63;
        String url = "/cobro/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/ch/PT";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (fromDate != null) {
            url = url + (char)urlParamsSep + "fch-rec-dsd=" + sdf.format(fromDate);
            urlParamsSep = 38;
        }
        if (toDate != null) {
            url = url + (char)urlParamsSep + "fch-rec-hst=" + sdf.format(toDate);
            urlParamsSep = 38;
        }
        return (EmpresaCobroListadoResponse)this.restConnector.genericGet(null, EmpresaCobroListadoResponse.class, ErrorResponse.class, url);
    }

    public EmpresaCobroDetalleResponse consultarDetallePosicionIntegralDeCobros(String subconvenio, String numeroCanal, String numeroConsulta, Date fechaRecuperoDesde, Date fechaRecuperoHasta, String deudor1, String deudor2, String comprobante1, String comprobante2, String comprobante3, String comprobante4, String comprobante5, int pagCant, int pagAct) throws RestConnectorException {
        String url = "/cobro/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/" + subconvenio + "/canal/" + numeroCanal + "/consulta/" + numeroConsulta;
        url = url + "?pag-cant=" + pagCant;
        url = url + "&pag-act=" + pagAct;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (fechaRecuperoDesde != null) {
            url = url + "&fch-rec-dsd=" + sdf.format(fechaRecuperoDesde);
        }
        if (fechaRecuperoHasta != null) {
            url = url + "&fch-rec-hst=" + sdf.format(fechaRecuperoHasta);
        }
        if (StringUtils.isNotEmpty((CharSequence)deudor1)) {
            url = url + "&deudor1=" + deudor1;
        }
        if (StringUtils.isNotEmpty((CharSequence)deudor2)) {
            url = url + "&deudor2=" + deudor2;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante1)) {
            url = url + "&comprobante1=" + comprobante1;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante2)) {
            url = url + "&comprobante2=" + comprobante2;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante3)) {
            url = url + "&comprobante3=" + comprobante3;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante4)) {
            url = url + "&comprobante4=" + comprobante4;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante5)) {
            url = url + "&comprobante5=" + comprobante5;
        }
        return (EmpresaCobroDetalleResponse)this.restConnector.genericGet(null, EmpresaCobroDetalleResponse.class, ErrorResponse.class, url);
    }

    public void historialPublicacionDeArchivos() {
    }

    public void consultaArchivosRecepcion() {
    }

    public void consultaEstadoArchivo() {
    }

    public void consultaErroresDelArchivo() {
    }

    public void generarTokenParaBajarArchivoDeCobranzas() {
    }

    public void bajarArchivoDeCobranzas() {
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-application-key", (Object)this.xApplicationId);
            if (!this.doingLogin) {
                builder.header("Authorization", (Object)("Bearer " + this.accessToken));
            }
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public LoginResponse generateAccessToken() throws RestConnectorException {
        Usuario usuario = new Usuario();
        usuario.setAlias(this.usuarioAlias);
        Documento documento = new Documento();
        documento.setTipo(this.documentoTipo);
        documento.setNumero(this.documentoNumero);
        Empresa empresa = new Empresa();
        empresa.setDocumento(documento);
        LoginRequest request = new LoginRequest();
        request.setUsuario(usuario);
        request.setEmpresa(empresa);
        log.debug("[loginAndGetAccessToken] Por hacer login y obtener token con [" + request + "]");
        this.doingLogin = true;
        Pair responsePair = this.restConnector.genericPostWithResponseHeader((Object)request, LoginResponse.class, "/v2/login/ch/PT");
        MultivaluedMap headers = (MultivaluedMap)responsePair.getValue();
        String xUid = null;
        List xUidList = (List)headers.get((Object)"x-uid");
        if (xUidList != null && !xUidList.isEmpty()) {
            xUid = (String)xUidList.get(0);
        }
        if (xUid == null || xUid.trim().isEmpty()) {
            throw new RuntimeException("No se pudo obtener el parametro [x-uid] del response header");
        }
        String xAccessToken = null;
        List xAccessTokenList = (List)headers.get((Object)"x-access-token");
        if (xAccessTokenList != null && !xAccessTokenList.isEmpty()) {
            xAccessToken = (String)xAccessTokenList.get(0);
        }
        if (xAccessToken == null || xAccessToken.trim().isEmpty()) {
            throw new RuntimeException("No se pudo obtener el parametro [x-access-token] del response header");
        }
        this.accessToken = Base64.getEncoder().encodeToString((xUid + ":" + xAccessToken).getBytes(StandardCharsets.UTF_8));
        log.debug("[loginAndGetAccessToken] Token recuperado y codificado a base64 [" + this.accessToken + "]");
        this.doingLogin = false;
        return (LoginResponse)responsePair.getKey();
    }

    public String generateUploadToken() throws RestConnectorException {
        log.debug("[generateUploadToken] Por obtener el token para subir el archivo");
        EmpresaArchivoTokenResponse empresaArchivoTokenResponse = (EmpresaArchivoTokenResponse)this.restConnector.genericPost((Object)new EmpresaArchivoTokenRequest(), EmpresaArchivoTokenResponse.class, "/archivo/token/sistema/CASH/accion/SUBIR/ch/PT");
        String uploadToken = null;
        List<Token> tokens = empresaArchivoTokenResponse.getToken();
        if (tokens != null && !tokens.isEmpty()) {
            uploadToken = tokens.get(0).getToken();
        }
        if (uploadToken == null || uploadToken.trim().isEmpty()) {
            throw new RuntimeException("[generateUploadToken] No se pudo obtener el parametro [tokenLista.token] del response");
        }
        log.debug("[generateUploadToken] Token para subir el archivo recuperado [" + uploadToken + "]");
        return uploadToken;
    }
}

