package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cheque implements Serializable {

    @JsonProperty("numero")
    private String numero;

    @JsonProperty("estado")
    private String estado;

    @JsonProperty("banco")
    private String banco;

    @JsonProperty("codigoPostal")
    private String codigoPostal;

    @JsonProperty("importe")
    private String importe;

    @JsonProperty("cuenta")
    private String cuenta;

    @JsonProperty("fechaRecaudacion")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaRecaudacion;

    @JsonProperty("sucursal")
    private String sucursal;

    @JsonProperty("moneda")
    private String moneda;

    @JsonProperty("nroRecaudacion")
    private String nroRecaudacion;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaAcreditacion;

    public String getNumero() {
        return numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getCodigoPostal() {
        return codigoPostal;
    }

    public void setCodigoPostal(String codigoPostal) {
        this.codigoPostal = codigoPostal;
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getCuenta() {
        return cuenta;
    }

    public void setCuenta(String cuenta) {
        this.cuenta = cuenta;
    }

    public Date getFechaRecaudacion() {
        return fechaRecaudacion;
    }

    public void setFechaRecaudacion(Date fechaRecaudacion) {
        this.fechaRecaudacion = fechaRecaudacion;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public String getNroRecaudacion() {
        return nroRecaudacion;
    }

    public void setNroRecaudacion(String nroRecaudacion) {
        this.nroRecaudacion = nroRecaudacion;
    }

    public Date getFechaAcreditacion() {
        return fechaAcreditacion;
    }

    public void setFechaAcreditacion(Date fechaAcreditacion) {
        this.fechaAcreditacion = fechaAcreditacion;
    }

    @Override
    public String toString() {
        return "Cheque [" +
                ((numero != null) ? "numero='" + numero + "', " : "") +
                ((estado != null) ? "estado='" + estado + "', " : "") +
                ((banco != null) ? "banco='" + banco + "', " : "") +
                ((codigoPostal != null) ? "codigoPostal='" + codigoPostal + "', " : "") +
                ((importe != null) ? "importe='" + importe + "', " : "") +
                ((cuenta != null) ? "cuenta='" + cuenta + "', " : "") +
                ((fechaRecaudacion != null) ? "fechaRecaudacion=" + fechaRecaudacion + ", " : "") +
                ((sucursal != null) ? "sucursal='" + sucursal + "', " : "") +
                ((moneda != null) ? "moneda='" + moneda + "', " : "") +
                ((nroRecaudacion != null) ? "nroRecaudacion='" + nroRecaudacion + "', " : "") +
                ((fechaAcreditacion != null) ? "fechaAcreditacion=" + fechaAcreditacion + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cheque cheque = (Cheque) o;
        return Objects.equals(numero, cheque.numero) && Objects.equals(estado, cheque.estado) && Objects.equals(banco, cheque.banco) && Objects.equals(codigoPostal, cheque.codigoPostal) && Objects.equals(importe, cheque.importe) && Objects.equals(cuenta, cheque.cuenta) && Objects.equals(fechaRecaudacion, cheque.fechaRecaudacion) && Objects.equals(sucursal, cheque.sucursal) && Objects.equals(moneda, cheque.moneda) && Objects.equals(nroRecaudacion, cheque.nroRecaudacion) && Objects.equals(fechaAcreditacion, cheque.fechaAcreditacion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numero, estado, banco, codigoPostal, importe, cuenta, fechaRecaudacion, sucursal, moneda, nroRecaudacion, fechaAcreditacion);
    }
}