package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.TokenLista;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GenerateUploadTokenResponse implements Serializable {

    @JsonProperty("tokenLista")
    private List<TokenLista> tokenLista;

    @JsonProperty("estadoEjecucion")
    private String estadoEjecucion;

    public List<TokenLista> getTokenLista() {
        return tokenLista;
    }

    public void setTokenLista(List<TokenLista> tokenLista) {
        this.tokenLista = tokenLista;
    }

    public String getEstadoEjecucion() {
        return estadoEjecucion;
    }

    public void setEstadoEjecucion(String estadoEjecucion) {
        this.estadoEjecucion = estadoEjecucion;
    }

    @Override
    public String toString() {
        return "GenerateUploadTokenResponse [" +
                ((tokenLista != null) ? "tokenLista=" + Arrays.toString(tokenLista.toArray()) + ", " : "") +
                ((estadoEjecucion != null) ? "estadoEjecucion=" + estadoEjecucion + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenerateUploadTokenResponse that = (GenerateUploadTokenResponse) o;
        return Objects.equals(tokenLista, that.tokenLista) && Objects.equals(estadoEjecucion, that.estadoEjecucion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tokenLista, estadoEjecucion);
    }
}