/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.FileUploadRequest;
import ar.com.sdd.patagoniaapi.io.FileUploadResponse;
import ar.com.sdd.patagoniaapi.io.GenerateUploadTokenRequest;
import ar.com.sdd.patagoniaapi.io.GenerateUploadTokenResponse;
import ar.com.sdd.patagoniaapi.io.LoginRequest;
import ar.com.sdd.patagoniaapi.io.LoginResponse;
import ar.com.sdd.patagoniaapi.model.Documento;
import ar.com.sdd.patagoniaapi.model.Empresa;
import ar.com.sdd.patagoniaapi.model.TokenLista;
import ar.com.sdd.patagoniaapi.model.Usuario;
import ar.com.sdd.patagoniaapi.util.SimpleCache;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class PatagoniaApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(PatagoniaApiConnector.class);
    private final RestConnector restConnector;
    private final String xApplicationId;
    private final String usuarioAlias;
    private final String documentoTipo;
    private final String documentoNumero;
    private boolean doingLogin = false;
    private final SimpleCache<String, String> cache;

    public PatagoniaApiConnector(PatagoniaApiConnectorContext context) {
        this.usuarioAlias = context.getPatagoniaApiUsuarioAlias();
        this.documentoTipo = context.getPatagoniaApiDocumentoTipo();
        this.documentoNumero = context.getPatagoniaApiDocumentoNumero();
        this.xApplicationId = context.getPatagoniaApiXApplicationKey();
        log.debug((Object)("Creando PatagoniaApiConnector con " + context));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getPatagoniaApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
        this.cache = SimpleCache.builder().maximumSize(1L).expireAfter(1L, ChronoUnit.MINUTES).build();
    }

    public FileUploadResponse publicarDeuda(String fileName, String fileInBase64) throws RestConnectorException {
        log.debug((Object)"[uploadFile] Por hacer upload del archivo");
        FileUploadRequest fileUploadRequest = new FileUploadRequest();
        fileUploadRequest.setToken(this.generateUploadToken());
        fileUploadRequest.setUserId("B2B-" + this.documentoNumero + "-0");
        fileUploadRequest.setFileName(fileName);
        fileUploadRequest.setFile(fileInBase64);
        return (FileUploadResponse)this.restConnector.genericPost((Object)fileUploadRequest, FileUploadResponse.class, "/archivo", "application/json", "application/x-www-form-urlencoded");
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-application-key", (Object)this.xApplicationId);
            if (!this.doingLogin) {
                builder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
            }
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken() throws RestConnectorException {
        String accessToken = this.cache.getIfPresent("accessToken");
        if (accessToken == null) {
            this.doingLogin = true;
            Usuario usuario = new Usuario();
            usuario.setAlias(this.usuarioAlias);
            Documento documento = new Documento();
            documento.setTipo(this.documentoTipo);
            documento.setNumero(this.documentoNumero);
            Empresa empresa = new Empresa();
            empresa.setDocumento(documento);
            LoginRequest request = new LoginRequest();
            request.setUsuario(usuario);
            request.setEmpresa(empresa);
            log.debug((Object)("[loginAndGetAccessToken] Por hacer login y obtener token con [" + request + "]"));
            Pair responsePair = this.restConnector.genericPostWithResponseHeader((Object)request, LoginResponse.class, "/v2/login/ch/PT");
            MultivaluedMap headers = (MultivaluedMap)responsePair.getValue();
            String xUid = null;
            List xUidList = (List)headers.get((Object)"x-uid");
            if (xUidList != null && !xUidList.isEmpty()) {
                xUid = (String)xUidList.get(0);
            }
            if (xUid == null || xUid.trim().length() == 0) {
                throw new RuntimeException("No se pudo obtener el parametro [x-uid] del response header");
            }
            String xAccessToken = null;
            List xAccessTokenList = (List)headers.get((Object)"x-access-token");
            if (xAccessTokenList != null && !xAccessTokenList.isEmpty()) {
                xAccessToken = (String)xAccessTokenList.get(0);
            }
            if (xAccessToken == null || xAccessToken.trim().length() == 0) {
                throw new RuntimeException("No se pudo obtener el parametro [x-access-token] del response header");
            }
            accessToken = Base64.getEncoder().encodeToString((xUid + ":" + xAccessToken).getBytes(StandardCharsets.UTF_8));
            log.debug((Object)("[loginAndGetAccessToken] Token recuperado y codificado a base64 [" + accessToken + "]. Lo agrego al a cache"));
            this.cache.put("accessToken", accessToken);
            this.doingLogin = false;
        }
        return accessToken;
    }

    public String generateUploadToken() throws RestConnectorException {
        log.debug((Object)"[generateUploadToken] Por obtener el token para subir el archivo");
        GenerateUploadTokenResponse generateUploadTokenResponse = (GenerateUploadTokenResponse)this.restConnector.genericPost((Object)new GenerateUploadTokenRequest(), GenerateUploadTokenResponse.class, "/archivo/token/sistema/CASH/accion/SUBIR/ch/PT");
        String uploadToken = null;
        List<TokenLista> tokens = generateUploadTokenResponse.getTokenLista();
        if (tokens != null && !tokens.isEmpty()) {
            uploadToken = tokens.get(0).getToken();
        }
        if (uploadToken == null || uploadToken.trim().length() == 0) {
            throw new RuntimeException("[generateUploadToken] No se pudo obtener el parametro [tokenLista.token] del response");
        }
        log.debug((Object)("[generateUploadToken] Token para subir el archivo recuperado [" + uploadToken + "]"));
        return uploadToken;
    }
}

