package ar.com.sdd.patagoniaapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.ws.rs.core.Form;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaArchivoRequest extends Form implements Serializable {

    @JsonProperty("token")
    private String token;

    @JsonProperty("userId")
    private String userId;

    @JsonProperty("file")
    private String file;

    @JsonProperty("fileName")
    private String fileName;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
        this.param("token", token);
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.param("userId", userId);
    }

    public String getFile() {
        return file;
    }

    public void setFile(String file) {
        this.file = file;
        this.param("file", file);
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.param("fileName", fileName);
    }

    @Override
    public String toString() {
        return "EmpresaArchivoRequest [" +
                ((token != null) ? "token=" + token + ", " : "") +
                ((userId != null) ? "userId=" + userId + ", " : "") +
                ((file != null) ? "file=" + file + ", " : "") +
                ((fileName != null) ? "fileName=" + fileName + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmpresaArchivoRequest that = (EmpresaArchivoRequest) o;
        return Objects.equals(token, that.token) && Objects.equals(userId, that.userId) && Objects.equals(file, that.file) && Objects.equals(fileName, that.fileName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(token, userId, file, fileName);
    }
}