package ar.com.sdd.patagoniaapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaCobroListadoRequest implements Serializable {

    @JsonProperty("fch-rec-dsd")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaRecuperoDesde;

    @JsonProperty("fch-rec-hst")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaRecuperoHasta;

    public Date getFechaRecuperoDesde() {
        return fechaRecuperoDesde;
    }

    public void setFechaRecuperoDesde(Date fechaRecuperoDesde) {
        this.fechaRecuperoDesde = fechaRecuperoDesde;
    }

    public Date getFechaRecuperoHasta() {
        return fechaRecuperoHasta;
    }

    public void setFechaRecuperoHasta(Date fechaRecuperoHasta) {
        this.fechaRecuperoHasta = fechaRecuperoHasta;
    }

    @Override
    public String toString() {
        return "EmpresaCobroListadoRequest{" +
                "fechaRecuperoDesde=" + fechaRecuperoDesde +
                ", fechaRecuperoHasta=" + fechaRecuperoHasta +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmpresaCobroListadoRequest that = (EmpresaCobroListadoRequest) o;
        return Objects.equals(fechaRecuperoDesde, that.fechaRecuperoDesde) && Objects.equals(fechaRecuperoHasta, that.fechaRecuperoHasta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fechaRecuperoDesde, fechaRecuperoHasta);
    }
}