/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroArchivoEstadoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroArchivoEstadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroListadoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroListadoResponse;
import ar.com.sdd.patagoniaapi.io.LoginRequest;
import ar.com.sdd.patagoniaapi.io.LoginResponse;
import ar.com.sdd.patagoniaapi.model.Documento;
import ar.com.sdd.patagoniaapi.model.Empresa;
import ar.com.sdd.patagoniaapi.model.ListaCobros;
import ar.com.sdd.patagoniaapi.model.Recaudacion;
import ar.com.sdd.patagoniaapi.model.Respuesta;
import ar.com.sdd.patagoniaapi.model.Token;
import ar.com.sdd.patagoniaapi.model.Usuario;
import ar.com.sdd.patagoniaapi.util.SimpleCache;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class PatagoniaApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(PatagoniaApiConnector.class);
    private final RestConnector restConnector;
    private final String xApplicationId;
    private final String usuarioAlias;
    private final String documentoTipo;
    private final String documentoNumero;
    private final String adherente;
    private final String convenio;
    private static final String channel = "PT";
    private boolean doingLogin = false;
    private final SimpleCache<String, String> cache;
    private static final String STATUS_OK = "OK";
    private static final String STATUS_ERROR = "ERROR";

    public PatagoniaApiConnector(PatagoniaApiConnectorContext context) {
        this.usuarioAlias = context.getPatagoniaApiUsuarioAlias();
        this.documentoTipo = context.getPatagoniaApiDocumentoTipo();
        this.documentoNumero = context.getPatagoniaApiDocumentoNumero();
        this.xApplicationId = context.getPatagoniaApiXApplicationKey();
        this.adherente = context.getPatagoniaApiAdherente();
        this.convenio = context.getPatagoniaApiConvenio();
        log.debug((Object)("Creando PatagoniaApiConnector con " + context));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getPatagoniaApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
        this.cache = SimpleCache.builder().maximumSize(1L).expireAfter(1L, ChronoUnit.MINUTES).build();
    }

    public EmpresaCobroArchivoEstadoResponse publicarDeuda(String fileName, String fileInBase64) throws RestConnectorException {
        Respuesta respuesta;
        log.debug((Object)"[uploadFile] Por hacer upload del archivo");
        EmpresaArchivoRequest empresaArchivoRequest = new EmpresaArchivoRequest();
        empresaArchivoRequest.setToken(this.generateUploadToken());
        empresaArchivoRequest.setUserId("B2B-" + this.documentoNumero + "-0");
        empresaArchivoRequest.setFileName(fileName);
        empresaArchivoRequest.setFile(fileInBase64);
        EmpresaArchivoResponse empresaArchivoResponse = (EmpresaArchivoResponse)this.restConnector.genericPost((Object)empresaArchivoRequest, EmpresaArchivoResponse.class, "/archivo", "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[uploadFile] Response: " + empresaArchivoResponse));
        if (empresaArchivoResponse != null && empresaArchivoResponse.getRespuesta() != null && (respuesta = empresaArchivoResponse.getRespuesta()).getCodigo().equals(STATUS_OK)) {
            return this.confirmarOperacion(empresaArchivoRequest.getToken(), fileName.substring(0, 2));
        }
        return null;
    }

    public EmpresaCobroArchivoEstadoResponse confirmarOperacion(String token, String tipoArchivo) throws RestConnectorException {
        log.debug((Object)"[confirmarOperacion] Por confirmar procesamiento del archivo que acabamos de subir");
        EmpresaCobroArchivoEstadoRequest empresaCobroArchivoEstadoRequest = new EmpresaCobroArchivoEstadoRequest();
        empresaCobroArchivoEstadoRequest.setToken(token);
        String docProd = this.documentoNumero;
        String subconvenio = "1";
        String confirmPath = "/archivo/prod/" + docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/estado/tipo-arch/" + tipoArchivo + "/doc-tp/" + this.documentoTipo + "/docNum/" + this.documentoNumero + "/ch/PT";
        return (EmpresaCobroArchivoEstadoResponse)this.restConnector.genericPost((Object)empresaCobroArchivoEstadoRequest, EmpresaCobroArchivoEstadoResponse.class, confirmPath);
    }

    public void consultaConvenioPorAdherente() {
    }

    public void postPaymentSet(String archivoId) throws RestConnectorException {
        String docProd = this.documentoNumero;
        EmpresaCobroListadoResponse empresaCobroListadoResponse = this.consultarPosicionIntegralDeCobros(docProd, archivoId, new Date(), new Date());
        log.info((Object)empresaCobroListadoResponse);
        if (empresaCobroListadoResponse != null && empresaCobroListadoResponse.getEstadoEjecucion().equalsIgnoreCase(STATUS_OK)) {
            for (Recaudacion recaudacion : empresaCobroListadoResponse.getRecaudacion()) {
                for (ListaCobros cobros : recaudacion.getListaCobros()) {
                    this.consultarDetallePosicionIntegralDeCobros(docProd, cobros.getSubconvenioId(), recaudacion.getCanal(), recaudacion.getNumeroConsulta());
                }
            }
        }
    }

    public EmpresaCobroListadoResponse consultarPosicionIntegralDeCobros(String docProd, String archivoId, Date fromDate, Date toDate) throws RestConnectorException {
        EmpresaCobroListadoRequest empresaCobroListadoRequest = new EmpresaCobroListadoRequest();
        empresaCobroListadoRequest.setFechaRecuperoDesde(fromDate);
        empresaCobroListadoRequest.setFechaRecuperoDesde(toDate);
        String url = "/archivo/estado/prod/" + docProd + "/adherentes/" + this.adherente + "/" + archivoId + "/ch/PT";
        return (EmpresaCobroListadoResponse)this.restConnector.genericPost((Object)empresaCobroListadoRequest, EmpresaCobroListadoResponse.class, url);
    }

    public void consultarDetallePosicionIntegralDeCobros(String docProd, String subconvenio, String numeroCanal, String numeroConsulta) {
        String url = "/cobro/prod/" + docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/" + subconvenio + "/canal/" + numeroCanal + "/consulta/" + numeroConsulta;
        log.info((Object)("por consultar: " + url));
    }

    public void historialPublicacionDeArchivos() {
    }

    public void consultaArchivosRecepcion() {
    }

    public void consultaEstadoArchivo() {
    }

    public void consultaErroresDelArchivo() {
    }

    public void generarTokenParaBajarArchivoDeCobranzas() {
    }

    public void bajarArchivoDeCobranzas() {
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-application-key", (Object)this.xApplicationId);
            if (!this.doingLogin) {
                builder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
            }
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken() throws RestConnectorException {
        String accessToken = this.cache.getIfPresent("accessToken");
        if (accessToken == null) {
            this.doingLogin = true;
            Usuario usuario = new Usuario();
            usuario.setAlias(this.usuarioAlias);
            Documento documento = new Documento();
            documento.setTipo(this.documentoTipo);
            documento.setNumero(this.documentoNumero);
            Empresa empresa = new Empresa();
            empresa.setDocumento(documento);
            LoginRequest request = new LoginRequest();
            request.setUsuario(usuario);
            request.setEmpresa(empresa);
            log.debug((Object)("[loginAndGetAccessToken] Por hacer login y obtener token con [" + request + "]"));
            Pair responsePair = this.restConnector.genericPostWithResponseHeader((Object)request, LoginResponse.class, "/v2/login/ch/PT");
            MultivaluedMap headers = (MultivaluedMap)responsePair.getValue();
            String xUid = null;
            List xUidList = (List)headers.get((Object)"x-uid");
            if (xUidList != null && !xUidList.isEmpty()) {
                xUid = (String)xUidList.get(0);
            }
            if (xUid == null || xUid.trim().length() == 0) {
                throw new RuntimeException("No se pudo obtener el parametro [x-uid] del response header");
            }
            String xAccessToken = null;
            List xAccessTokenList = (List)headers.get((Object)"x-access-token");
            if (xAccessTokenList != null && !xAccessTokenList.isEmpty()) {
                xAccessToken = (String)xAccessTokenList.get(0);
            }
            if (xAccessToken == null || xAccessToken.trim().length() == 0) {
                throw new RuntimeException("No se pudo obtener el parametro [x-access-token] del response header");
            }
            accessToken = Base64.getEncoder().encodeToString((xUid + ":" + xAccessToken).getBytes(StandardCharsets.UTF_8));
            log.debug((Object)("[loginAndGetAccessToken] Token recuperado y codificado a base64 [" + accessToken + "]. Lo agrego al a cache"));
            this.cache.put("accessToken", accessToken);
            this.doingLogin = false;
        }
        return accessToken;
    }

    public String generateUploadToken() throws RestConnectorException {
        log.debug((Object)"[generateUploadToken] Por obtener el token para subir el archivo");
        EmpresaArchivoTokenResponse empresaArchivoTokenResponse = (EmpresaArchivoTokenResponse)this.restConnector.genericPost((Object)new EmpresaArchivoTokenRequest(), EmpresaArchivoTokenResponse.class, "/archivo/token/sistema/CASH/accion/SUBIR/ch/PT");
        String uploadToken = null;
        List<Token> tokens = empresaArchivoTokenResponse.getToken();
        if (tokens != null && !tokens.isEmpty()) {
            uploadToken = tokens.get(0).getToken();
        }
        if (uploadToken == null || uploadToken.trim().length() == 0) {
            throw new RuntimeException("[generateUploadToken] No se pudo obtener el parametro [tokenLista.token] del response");
        }
        log.debug((Object)("[generateUploadToken] Token para subir el archivo recuperado [" + uploadToken + "]"));
        return uploadToken;
    }
}

