package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaArchivoResponse implements Serializable {

    private Respuesta respuesta;

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    @Override
    public String toString() {
        return "EmpresaArchivoResponse [" +
                ((respuesta != null) ? "respuesta=" + respuesta + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmpresaArchivoResponse that = (EmpresaArchivoResponse) o;
        return Objects.equals(respuesta, that.respuesta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(respuesta);
    }
}