package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.Error;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CommonResponse implements Serializable {

    @JsonProperty("estadoEjecucion")
    private String estadoEjecucion;

    @JsonProperty("error")
    private Error error;


    public String getEstadoEjecucion() {
        return estadoEjecucion;
    }

    public void setEstadoEjecucion(String estadoEjecucion) {
        this.estadoEjecucion = estadoEjecucion;
    }

    public Error getError() {
        return error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    @Override
    public String toString() {
        return "CommonResponse{" +
                "estadoEjecucion='" + estadoEjecucion + '\'' +
                ", error=" + error +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonResponse that = (CommonResponse) o;
        return Objects.equals(estadoEjecucion, that.estadoEjecucion) && Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(estadoEjecucion, error);
    }
}