package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.MedioPago;
import ar.com.sdd.patagoniaapi.model.Pagina;
import ar.com.sdd.patagoniaapi.model.Recaudacion;
import ar.com.sdd.patagoniaapi.model.Resumen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaCobroDetalleResponse extends CommonResponse implements Serializable {

    @JsonProperty("medioPagoLista")
    private List<MedioPago> medioPago;

    @JsonProperty("recaudacionLista")
    private List<Recaudacion> recaudacion;

    @JsonProperty("resumenLista")
    private List<Resumen> resumen;

    @JsonProperty("pagina")
    private List<Pagina> pagina;

    public List<MedioPago> getMedioPago() {
        return medioPago;
    }

    public void setMedioPago(List<MedioPago> medioPago) {
        this.medioPago = medioPago;
    }

    public List<Recaudacion> getRecaudacion() {
        return recaudacion;
    }

    public void setRecaudacion(List<Recaudacion> recaudacion) {
        this.recaudacion = recaudacion;
    }

    public List<Resumen> getResumen() {
        return resumen;
    }

    public void setResumen(List<Resumen> resumen) {
        this.resumen = resumen;
    }

    public List<Pagina> getPagina() {
        return pagina;
    }

    public void setPagina(List<Pagina> pagina) {
        this.pagina = pagina;
    }

    @Override
    public String toString() {
        return "EmpresaCobroDetalleResponse{" +
                "medioPago=" + medioPago +
                ", recaudacion=" + recaudacion +
                ", resumen=" + resumen +
                ", pagina=" + pagina +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaCobroDetalleResponse that = (EmpresaCobroDetalleResponse) o;
        return Objects.equals(medioPago, that.medioPago) && Objects.equals(recaudacion, that.recaudacion) && Objects.equals(resumen, that.resumen) && Objects.equals(pagina, that.pagina);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), medioPago, recaudacion, resumen, pagina);
    }
}