package ar.com.sdd.patagoniaapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaCobroDetalleRequest implements Serializable {

    @JsonProperty("fch-rec-dsd")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaRecuperoDesde; // Requerido: No

    @JsonProperty("fch-rec-hst")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaRecuperoHasta; // Requerido: No

    @JsonProperty("deudor1")
    private String deudor1; // Requerido: No

    @JsonProperty("deudor2")
    private String deudor2; // Requerido: No

    @JsonProperty("comprobante1")
    private String comprobante1; // Requerido: No

    @JsonProperty("comprobante2")
    private String comprobante2; // Requerido: No

    @JsonProperty("comprobante3")
    private String comprobante3; // Requerido: No

    @JsonProperty("comprobante4")
    private String comprobante4; // Requerido: No

    @JsonProperty("comprobante5")
    private String comprobante5; // Requerido: No

    @JsonProperty("pag-cant")
    private int cobrosPorPagina; // Requerido: Si

    @JsonProperty("pag-act")
    private int numeroDePagina; // Requerido: Si

    @JsonProperty("gw-app-key")
    private String gwApplicationKey; // API KEY Requerido: Si

    public Date getFechaRecuperoDesde() {
        return fechaRecuperoDesde;
    }

    public void setFechaRecuperoDesde(Date fechaRecuperoDesde) {
        this.fechaRecuperoDesde = fechaRecuperoDesde;
    }

    public Date getFechaRecuperoHasta() {
        return fechaRecuperoHasta;
    }

    public void setFechaRecuperoHasta(Date fechaRecuperoHasta) {
        this.fechaRecuperoHasta = fechaRecuperoHasta;
    }

    public String getDeudor1() {
        return deudor1;
    }

    public void setDeudor1(String deudor1) {
        this.deudor1 = deudor1;
    }

    public String getDeudor2() {
        return deudor2;
    }

    public void setDeudor2(String deudor2) {
        this.deudor2 = deudor2;
    }

    public String getComprobante1() {
        return comprobante1;
    }

    public void setComprobante1(String comprobante1) {
        this.comprobante1 = comprobante1;
    }

    public String getComprobante2() {
        return comprobante2;
    }

    public void setComprobante2(String comprobante2) {
        this.comprobante2 = comprobante2;
    }

    public String getComprobante3() {
        return comprobante3;
    }

    public void setComprobante3(String comprobante3) {
        this.comprobante3 = comprobante3;
    }

    public String getComprobante4() {
        return comprobante4;
    }

    public void setComprobante4(String comprobante4) {
        this.comprobante4 = comprobante4;
    }

    public String getComprobante5() {
        return comprobante5;
    }

    public void setComprobante5(String comprobante5) {
        this.comprobante5 = comprobante5;
    }

    public int getCobrosPorPagina() {
        return cobrosPorPagina;
    }

    public void setCobrosPorPagina(int cobrosPorPagina) {
        this.cobrosPorPagina = cobrosPorPagina;
    }

    public int getNumeroDePagina() {
        return numeroDePagina;
    }

    public void setNumeroDePagina(int numeroDePagina) {
        this.numeroDePagina = numeroDePagina;
    }

    public String getGwApplicationKey() {
        return gwApplicationKey;
    }

    public void setGwApplicationKey(String gwApplicationKey) {
        this.gwApplicationKey = gwApplicationKey;
    }

    @Override
    public String toString() {
        return "EmpresaCobroDetalleRequest{" +
                "fechaRecuperoDesde=" + fechaRecuperoDesde +
                ", fechaRecuperoHasta=" + fechaRecuperoHasta +
                ", duedor1='" + deudor1 + '\'' +
                ", deudor2='" + deudor2 + '\'' +
                ", comprobante1='" + comprobante1 + '\'' +
                ", comprobante2='" + comprobante2 + '\'' +
                ", comprobante3='" + comprobante3 + '\'' +
                ", comprobante4='" + comprobante4 + '\'' +
                ", comprobante5='" + comprobante5 + '\'' +
                ", cobrosPorPagina='" + cobrosPorPagina + '\'' +
                ", numeroDePagina='" + numeroDePagina + '\'' +
                ", gwApplicationKey='" + gwApplicationKey + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmpresaCobroDetalleRequest that = (EmpresaCobroDetalleRequest) o;
        return Objects.equals(fechaRecuperoDesde, that.fechaRecuperoDesde) && Objects.equals(fechaRecuperoHasta, that.fechaRecuperoHasta) && Objects.equals(deudor1, that.deudor1) && Objects.equals(deudor2, that.deudor2) && Objects.equals(comprobante1, that.comprobante1) && Objects.equals(comprobante2, that.comprobante2) && Objects.equals(comprobante3, that.comprobante3) && Objects.equals(comprobante4, that.comprobante4) && Objects.equals(comprobante5, that.comprobante5) && Objects.equals(cobrosPorPagina, that.cobrosPorPagina) && Objects.equals(numeroDePagina, that.numeroDePagina) && Objects.equals(gwApplicationKey, that.gwApplicationKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fechaRecuperoDesde, fechaRecuperoHasta, deudor1, deudor2, comprobante1, comprobante2, comprobante3, comprobante4, comprobante5, cobrosPorPagina, numeroDePagina, gwApplicationKey);
    }
}