package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Error implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("idOperacion")
    private String idOperacion;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getIdOperacion() {
        return idOperacion;
    }

    public void setIdOperacion(String idOperacion) {
        this.idOperacion = idOperacion;
    }

    @Override
    public String toString() {
        return "Error{" +
                "id='" + id + '\'' +
                ", descripcion='" + descripcion + '\'' +
                ", idOperacion='" + idOperacion + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Error error = (Error) o;
        return Objects.equals(id, error.id) && Objects.equals(descripcion, error.descripcion) && Objects.equals(idOperacion, error.idOperacion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, descripcion, idOperacion);
    }
}