package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Evento implements Serializable {

    @JsonProperty("fechaEvento")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMddHHmmssSSSZZZZ", timezone = "GMT-03:00")
    private Date fechaEvento;

    @JsonProperty("descripcionEvento")
    private String descripcionEvento;

    public Date getFechaEvento() {
        return fechaEvento;
    }

    public void setFechaEvento(Date fechaEvento) {
        this.fechaEvento = fechaEvento;
    }

    public String getDescripcionEvento() {
        return descripcionEvento;
    }

    public void setDescripcionEvento(String descripcionEvento) {
        this.descripcionEvento = descripcionEvento;
    }

    @Override
    public String toString() {
        return "Evento [" +
                ((fechaEvento != null) ? "fechaEvento=" + fechaEvento + ", " : "") +
                ((descripcionEvento != null) ? "descripcionEvento='" + descripcionEvento + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Evento evento = (Evento) o;
        return Objects.equals(fechaEvento, evento.fechaEvento) && Objects.equals(descripcionEvento, evento.descripcionEvento);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fechaEvento, descripcionEvento);
    }
}