package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoEstadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroChequesDetalleResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroDetalleResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroListadoResponse;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Date;

@SuppressWarnings("unused")
public class PatagoniaApiCobrosConnector extends PatagoniaApiConnectorBase {

    private final static Logger log = LogManager.getLogger(PatagoniaApiCobrosConnector.class);

    public PatagoniaApiCobrosConnector(PatagoniaApiConnectorContext context) {
        super(context);
    }

    public EmpresaArchivoEstadoResponse publicarDeuda(String fileName, String fileInBase64) throws RestConnectorException {
        return uploadFile(fileName, fileInBase64);
    }

    public void consultaConvenioPorAdherente() {
        // 5 - Metodo no implementado - ver documentacion - No nos aporta nada
    }

    public EmpresaCobroListadoResponse consultarPosicionIntegralDeCobros(Date fromDate, Date toDate) throws RestConnectorException {
        generateAccessToken();
        char urlParamsSep = '?';
        String url = "/cobro/prod/" + docProd + "/adherentes/" + adherente + "/" + convenio + "/1/ch/" + channel;

        if (fromDate != null) {
            url += urlParamsSep + "fch-rec-dsd=" + sdf.format(fromDate);
            urlParamsSep = '&';
        }
        if (toDate != null) {
            url += urlParamsSep + "fch-rec-hst=" + sdf.format(toDate);
            urlParamsSep = '&';
        }
        return restConnector.genericGet(null, EmpresaCobroListadoResponse.class, ErrorResponse.class, url);
    }

    /**
     * @param pagCant Cantidad de elementos por pagina del paginador
     * @param pagAct  Numero de pagina del paginador
     */
    public EmpresaCobroDetalleResponse consultarDetallePosicionIntegralDeCobros(String subconvenio, String numeroCanal, String numeroConsulta, Date fechaRecuperoDesde, Date fechaRecuperoHasta, String deudor1, String deudor2,
                                                                                String comprobante1, String comprobante2, String comprobante3, String comprobante4, String comprobante5, int pagCant, int pagAct) throws RestConnectorException{
        String url = "/cobro/prod/" + docProd + "/adherentes/"  + adherente + "/" + convenio + "/"  + subconvenio + "/canal/" + numeroCanal + "/consulta/" + numeroConsulta;
        url += "?pag-cant=" + pagCant;
        url += "&pag-act=" + pagAct;

        if (fechaRecuperoDesde != null) {
            url += "&fch-rec-dsd=" + sdf.format(fechaRecuperoDesde);
        }
        if (fechaRecuperoHasta != null) {
            url += "&fch-rec-hst=" + sdf.format(fechaRecuperoHasta);
        }
        if (StringUtils.isNotEmpty(deudor1)) {
            url += "&deudor1=" + deudor1;
        }
        if (StringUtils.isNotEmpty(deudor2)) {
            url += "&deudor2=" + deudor2;
        }
        if (StringUtils.isNotEmpty(comprobante1)) {
            url += "&comprobante1=" + comprobante1;
        }
        if (StringUtils.isNotEmpty(comprobante2)) {
            url += "&comprobante2=" + comprobante2;
        }
        if (StringUtils.isNotEmpty(comprobante3)) {
            url += "&comprobante3=" + comprobante3;
        }
        if (StringUtils.isNotEmpty(comprobante4)) {
            url += "&comprobante4=" + comprobante4;
        }
        if (StringUtils.isNotEmpty(comprobante5)) {
            url += "&comprobante5=" + comprobante5;
        }
        return restConnector.genericGet(null, EmpresaCobroDetalleResponse.class, ErrorResponse.class, url);
    }

    public void historialPublicacionDeArchivos() {
        // 8 - Metodo no implementado - ver documentacion - No nos aporta nada
    }

    public void consultaArchivosRecepcion() {
        // 9 - Metodo no implementado - ver documentacion - No nos aporta nada
    }

    public void generarTokenParaBajarArchivoDeCobranzas(){
        // 12 - Implementar
    }

    public void bajarArchivoDeCobranzas() {
        // 13 - Implementar
    }

    public EmpresaCobroChequesDetalleResponse consultarPosicionIntegralDeCobrosCheques(Date fromDate, Date toDate) throws RestConnectorException {
        generateAccessToken();
        char urlParamsSep = '?';
        String url = "/cobro/cheques/prod/" + docProd + "/adherentes/" + adherente + "/" + convenio + "/1/ch/" + channel;

        if (fromDate != null) {
            url += urlParamsSep + "fch-rec-dsd=" + sdf.format(fromDate);
            urlParamsSep = '&';
        }
        if (toDate != null) {
            url += urlParamsSep + "fch-rec-hst=" + sdf.format(toDate);
            urlParamsSep = '&';
        }
        return restConnector.genericGet(null, EmpresaCobroChequesDetalleResponse.class, ErrorResponse.class, url);
    }
}