package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.patagoniaapi.io.*;
import ar.com.sdd.patagoniaapi.model.EmpresaChequeEstadoDetalladoResponse;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.math.BigDecimal;
import java.util.Date;

@SuppressWarnings("unused")
public class PatagoniaApiPagosConnector extends PatagoniaApiConnectorBase {

    private final static Logger log = LogManager.getLogger(PatagoniaApiPagosConnector.class);

    public PatagoniaApiPagosConnector(PatagoniaApiConnectorContext context) {
        super(context);
    }

    public EmpresaArchivoEstadoResponse publicarOrdenesDePago(String fileName, String fileInBase64) throws RestConnectorException {
        return uploadFile(fileName, fileInBase64);
    }

    /**
     * 5 - Consulta de Órdenes de Pago - Permite realizar la consulta de órdenes de pago de un adherente.
     *                                   Admite la utilización de filtros de búsqueda y paginación de resultados
     */
    public EmpresaPagoListadoResponse consultaOrdenesDePago(Integer pagAct, Integer pagCant, String cbu, String ordenPagoId,
                                                            Date fechaEjecucionDesde, Date fechaEjecucionHasta,
                                                            String referenciaClienteDesde, String referenciaClienteHasta,
                                                            String nombreBeneficiario, String documentoBeneficiario,
                                                            BigDecimal importeDesde, BigDecimal importeHasta,
                                                            String paymentMethodIds, String paymentStatusIds) throws RestConnectorException {
        if (pagAct == null) pagAct = 1;
        if (pagCant == null) pagCant = 300;

        String path = "/pago/prod/" + docProd + "/adherentes/" + adherente + "/ch/" + channel + "?pag-act=" + pagAct + "&pag-cant=" + pagCant;

        if (cbu != null && !cbu.isEmpty()) {
            path += "&cbu=" + cbu;
        }

        if (ordenPagoId != null && !ordenPagoId.isEmpty()) {
            path += "&ordenPago.IDsegunCliente=" + ordenPagoId;
        }

        if (fechaEjecucionDesde != null) {
            path += "&fec-eje-dsd=" + sdf.format(fechaEjecucionDesde);
        }

        if (fechaEjecucionHasta != null) {
            path += "&fec-eje-hst=" + sdf.format(fechaEjecucionHasta);
        }

        if (referenciaClienteDesde != null && !referenciaClienteDesde.isEmpty()) {
            path += "&ref-cli-dsd=" + referenciaClienteDesde;
        }

        if (referenciaClienteHasta != null && !referenciaClienteHasta.isEmpty()) {
            path += "&ref-cli-hst=" + referenciaClienteHasta;
        }

        if (nombreBeneficiario != null && !nombreBeneficiario.isEmpty()) {
            path += "&benef-denom=" + nombreBeneficiario;
        }

        if (documentoBeneficiario != null && !documentoBeneficiario.isEmpty()) {
            path += "&benef-doc=" + documentoBeneficiario;
        }

        if (importeDesde != null) {
            path += "&importe-dsd=" + importeDesde;
        }

        if (importeHasta != null) {
            path += "&importe-hst=" + importeHasta;
        }

        if (paymentMethodIds != null && !paymentMethodIds.isEmpty()) {
            path += "&pag-met-id=" + paymentMethodIds;
        }

        if (paymentStatusIds != null && !paymentStatusIds.isEmpty()) {
            path += "&pag-std-id=" + paymentStatusIds;
        }

        return restConnector.genericGet(null, EmpresaPagoListadoResponse.class, ErrorResponse.class, path);
    }

    /**
     * 6 - Consulta de Detalles de Orden de Pago - Permite realizar la consulta detallada de una orden de pago de un adherente
     */
    public EmpresaPagoDetalleResponse consultaDetallesDeOrdenDePago(long operacionId, Long subOperacionId) throws RestConnectorException {
        String path = "/pago/prod/" + docProd + "/adherentes/" + adherente + "/" + operacionId;
        if (subOperacionId != null) {
            path += "/" + subOperacionId;
        }
        path += "/ch/" + channel;
        return restConnector.genericGet(null, EmpresaPagoDetalleResponse.class, ErrorResponse.class, path);
    }

    /**
     * 7 - Consulta de Cheques - Muestra en una lista la situación general de los cheques de pagos de un adherente, convenio, subconvenio, estado y otros campos filtro
     */
    public EmpresaChequeEstadoDetalladoResponse consultaCheques(Integer pagAct, Integer pagCant, String cuenta,
                                                                String numeroChequeDesde, String numeroChequeHasta,
                                                                String nombreBeneficiario, String documentoBeneficiario,
                                                                BigDecimal importeDesde, BigDecimal importeHasta,
                                                                String paymentStatusIds) throws RestConnectorException {
        if (pagAct == null) pagAct = 1;
        if (pagCant == null) pagCant = 300;

        String path = "/pago/prod/" + docProd + "/adherentes/" + adherente + "/ch/" + channel + "?pag-act=" + pagAct + "&pag-cant=" + pagCant;

        if (cuenta != null && !cuenta.isEmpty()) {
            path += "&cuenta=" + cuenta;
        }

        if (numeroChequeDesde != null) {
            path += "&id-dsd=" + sdf.format(numeroChequeDesde);
        }

        if (numeroChequeHasta != null) {
            path += "&id-hst=" + sdf.format(numeroChequeHasta);
        }

        if (nombreBeneficiario != null && !nombreBeneficiario.isEmpty()) {
            path += "&benef-denom=" + nombreBeneficiario;
        }

        if (documentoBeneficiario != null && !documentoBeneficiario.isEmpty()) {
            path += "&benef-doc=" + documentoBeneficiario;
        }

        if (importeDesde != null) {
            path += "&monto-dsd=" + importeDesde;
        }

        if (importeHasta != null) {
            path += "&monto-hst=" + importeHasta;
        }

        if (paymentStatusIds != null && !paymentStatusIds.isEmpty()) {
            path += "&lista-check=" + paymentStatusIds;
        }

        return restConnector.genericGet(null, EmpresaChequeEstadoDetalladoResponse.class, ErrorResponse.class, path);
    }

    /**
     * 8 - Consulta de Envios - Permite consultar el estado de los archivos de pagos
     */
    public EmpresaPagosHistoricosResponse consultaEnvios(String archivoTipo, Integer pagAct, Integer pagCant,
                                                         String nombreIngresante, String apellidoIngresante,
                                                         Date fechaRecepcionDesde, Date fechaRecepcionHasta,
                                                         String archivoEstado) throws RestConnectorException {
        if (pagAct == null) pagAct = 1;
        if (pagCant == null) pagCant = 300;

        String path = "/pago/" + adherente + "/adherentes/pagos/archivoTipo/" + archivoTipo + "?pag-act=" + pagAct + "&pag-cant=" + pagCant;

        if (nombreIngresante != null && !nombreIngresante.isEmpty()) {
            path += "&nom=" + nombreIngresante;
        }

        if (apellidoIngresante != null && !apellidoIngresante.isEmpty()) {
            path += "&ape=" + apellidoIngresante;
        }

        if (archivoEstado != null && !archivoEstado.isEmpty()) {
            path += "&archivo-estado=" + archivoEstado;
        }

        if (fechaRecepcionDesde != null) {
            path += "&fecha-dsd=" + sdf.format(fechaRecepcionDesde);
        }

        if (fechaRecepcionHasta != null) {
            path += "&fecha-hst=" + sdf.format(fechaRecepcionHasta);
        }

        return restConnector.genericGet(null, EmpresaPagosHistoricosResponse.class, ErrorResponse.class, path);
    }

    /**
     * 9 - Consulta de Flujo de Egresos - Con este método permite conocer los fondos que necesitará para hacer frente a los pagos como así también gastos, comisiones e impuestos.
     */
    public EmpresaPagosHistoricosResponse consultaFlujoEgresos() throws RestConnectorException {
        final String path = "/pago/egresos/cuit/" + docProd + "/adherente/" + adherente + "/ch/" + channel;
        return restConnector.genericGet(null, EmpresaPagosHistoricosResponse.class, ErrorResponse.class, path);
    }

    /**
     * 12 - Consulta de Contenido del Archivo - Consulta el contenido de un archivo mediante el servicio de subida
     */
    private EmpresaOrdenPagoResponse consultaContenidoArchivo(String archivoId, Integer pagAct, Integer pagCant) throws RestConnectorException {
        if (pagAct == null) pagAct = 1;
        if (pagCant == null) pagCant = 300;
        final String path = "/archivo/orden-pago/" + archivoId + "/prod/" + docProd + "/adherentes/" + adherente + "/ch/" + channel + "?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        return restConnector.genericGet(null, EmpresaOrdenPagoResponse.class, ErrorResponse.class, path);
    }

    /**
     * 13 - Consulta de Cuentas Pagos Cash - Consulta de cuentas pagos Cash por Adherente
     */
    private EmpresaCuentasResponse consultaCuentasPagosCash(String archivoId, Integer pagAct, Integer pagCant) throws RestConnectorException {
        if (pagAct == null) pagAct = 1;
        if (pagCant == null) pagCant = 300;
        // TODO: Esta repetido el link con el metodo 12 en la documentacion
        final String path = "/archivo/orden-pago/" + archivoId + "/prod/" + docProd + "/adherentes/" + adherente + "/ch/" + channel + "?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        return restConnector.genericGet(null, EmpresaCuentasResponse.class, ErrorResponse.class, path);
    }

    /**
     * 14 - Consulta de Recepción de Archivos - Permite consultar la información generada relacionada a las órdenes de pago
     */
    private EmpresaArchivosDevolucionResponse consultaRecepcionArchivo(Integer pagAct, Integer pagCant,
                                                                       String archivoTipo, String archivoEstado,
                                                                       Date fechaDesde, Date fechaHasta) throws RestConnectorException {
        if (pagAct == null) pagAct = 1;
        if (pagCant == null) pagCant = 300;
        String path = "/archivo/devolucion/prod/" + docProd + "/adherentes/" + adherente + "/ch/" + channel + "?pag-act=" + pagAct + "&pag-cant=" + pagCant;

        if (archivoTipo != null && !archivoTipo.isEmpty()) {
            path += "&archivo-tipo=" + archivoTipo;
        }

        if (archivoEstado != null && !archivoEstado.isEmpty()) {
            path += "&archivo-estado=" + archivoEstado;
        }

        if (fechaDesde != null) {
            path += "&fecha-dsd=" + sdf.format(fechaDesde);
        }

        if (fechaHasta != null) {
            path += "&fecha-hst=" + sdf.format(fechaHasta);
        }
        return restConnector.genericGet(null, EmpresaArchivosDevolucionResponse.class, ErrorResponse.class, path);
    }

    /**
     * 15 - Generar Archivo a Descargar - Solicita la generación del archivo y lo deja preparado para ser descargado
     */
    private EmpresaArchivoSubidoDescargaResponse generarArchivo(String archivoId) throws RestConnectorException {
        final String path = "/prod/" + docProd + "/adherentes/" + adherente + "archivos-rpocesado/" + archivoId + "/ch/" + channel;
        return restConnector.genericGet(null, EmpresaArchivoSubidoDescargaResponse.class, ErrorResponse.class, path);
    }

    /**
     * 16 - Descarga de Archivos - Se ejecuta la descarga del archivo
     */
    private String descargarArchivo(String token) throws RestConnectorException {
        final String path = "/archivo?" + token;
        return restConnector.genericGet(null, String.class, ErrorResponse.class, path);
    }
}