package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Comprobante implements Serializable {

    @JsonProperty("esCertificado")
    private String esCertificado;

    @JsonProperty("esEntregaContraReciboOficial")
    private String esEntregaContraReciboOficial;

    @JsonProperty("esComprobanteAdjunto")
    private String esComprobanteAdjunto;

    public String getEsCertificado() {
        return esCertificado;
    }

    public void setEsCertificado(String esCertificado) {
        this.esCertificado = esCertificado;
    }

    public String getEsEntregaContraReciboOficial() {
        return esEntregaContraReciboOficial;
    }

    public void setEsEntregaContraReciboOficial(String esEntregaContraReciboOficial) {
        this.esEntregaContraReciboOficial = esEntregaContraReciboOficial;
    }

    public String getEsComprobanteAdjunto() {
        return esComprobanteAdjunto;
    }

    public void setEsComprobanteAdjunto(String esComprobanteAdjunto) {
        this.esComprobanteAdjunto = esComprobanteAdjunto;
    }

    @Override
    public String toString() {
        return "Comprobante [" +
                ((esCertificado != null) ? "esCertificado='" + esCertificado + "', " : "") +
                ((esEntregaContraReciboOficial != null) ? "esEntregaContraReciboOficial='" + esEntregaContraReciboOficial + "', " : "") +
                ((esComprobanteAdjunto != null) ? "esComprobanteAdjunto='" + esComprobanteAdjunto + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Comprobante that = (Comprobante) o;
        return Objects.equals(esCertificado, that.esCertificado) && Objects.equals(esEntregaContraReciboOficial, that.esEntregaContraReciboOficial) && Objects.equals(esComprobanteAdjunto, that.esComprobanteAdjunto);
    }

    @Override
    public int hashCode() {
        return Objects.hash(esCertificado, esEntregaContraReciboOficial, esComprobanteAdjunto);
    }
}