package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ComprobanteWrapper implements Serializable {

    @JsonProperty("comprobante")
    private Comprobante comprobante;

    public Comprobante getComprobante() {
        return comprobante;
    }

    public void setComprobante(Comprobante comprobante) {
        this.comprobante = comprobante;
    }

    @Override
    public String toString() {
        return "ComprobanteWrapper [" +
                ((comprobante != null) ? "comprobante=" + comprobante + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ComprobanteWrapper that = (ComprobanteWrapper) o;
        return Objects.equals(comprobante, that.comprobante);
    }

    @Override
    public int hashCode() {
        return Objects.hash(comprobante);
    }
}