package ar.com.sdd.patagoniaapi.model;

import ar.com.sdd.patagoniaapi.io.CommonResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaChequeEstadoDetalladoResponse extends CommonResponse implements Serializable {

    @JsonProperty("pagina")
    private Pagina pagina;

    @JsonProperty("cheque")
    private Cheque cheque;

    @JsonProperty("chequeLista")
    private List<Cheque> cheques;

    public Pagina getPagina() {
        return pagina;
    }

    public void setPagina(Pagina pagina) {
        this.pagina = pagina;
    }

    public Cheque getCheque() {
        return cheque;
    }

    public void setCheque(Cheque cheque) {
        this.cheque = cheque;
    }

    public List<Cheque> getCheques() {
        return cheques;
    }

    public void setCheques(List<Cheque> cheques) {
        this.cheques = cheques;
    }

    @Override
    public String toString() {
        return "EmpresaChequeEstadoDetalladoResponse [" +
                ((pagina != null) ? "pagina=" + pagina + ", " : "") +
                ((cheque != null) ? "cheque=" + cheque + ", " : "") +
                ((cheques != null) ? "cheques=" + Arrays.toString(cheques.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaChequeEstadoDetalladoResponse that = (EmpresaChequeEstadoDetalladoResponse) o;
        return Objects.equals(pagina, that.pagina) && Objects.equals(cheque, that.cheque) && Objects.equals(cheques, that.cheques);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), pagina, cheque, cheques);
    }
}