package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Firmante implements Serializable {

    @JsonProperty("fechaFirma")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMddHHmmssSSSZZZZ", timezone = "GMT-03:00")
    private Date fechaFirma;

    @JsonProperty("nombre")
    private String nombre;

    @JsonProperty("apellido")
    private String apellido;

    public Date getFechaFirma() {
        return fechaFirma;
    }

    public void setFechaFirma(Date fechaFirma) {
        this.fechaFirma = fechaFirma;
    }

    public String getNombre() {
        return nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public String getApellido() {
        return apellido;
    }

    public void setApellido(String apellido) {
        this.apellido = apellido;
    }

    @Override
    public String toString() {
        return "Firmante [" +
                ((fechaFirma != null) ? "fechaFirma=" + fechaFirma + ", " : "") +
                ((nombre != null) ? "nombre='" + nombre + "', " : "") +
                ((apellido != null) ? "apellido='" + apellido + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Firmante firmante = (Firmante) o;
        return Objects.equals(fechaFirma, firmante.fechaFirma) && Objects.equals(nombre, firmante.nombre) && Objects.equals(apellido, firmante.apellido);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fechaFirma, nombre, apellido);
    }
}