package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MedioPago implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("importe")
    private String importe;

    @JsonProperty("porcentaje")
    private String porcentaje;

    @JsonProperty("cantidad")
    private String cantidad;

    @JsonProperty("moneda")
    private Moneda moneda;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getPorcentaje() {
        return porcentaje;
    }

    public void setPorcentaje(String porcentaje) {
        this.porcentaje = porcentaje;
    }

    public String getCantidad() {
        return cantidad;
    }

    public void setCantidad(String cantidad) {
        this.cantidad = cantidad;
    }

    public Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(Moneda moneda) {
        this.moneda = moneda;
    }

    @Override
    public String toString() {
        return "MedioPago [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((descripcion != null) ? "descripcion='" + descripcion + "', " : "") +
                ((importe != null) ? "importe='" + importe + "', " : "") +
                ((porcentaje != null) ? "porcentaje='" + porcentaje + "', " : "") +
                ((cantidad != null) ? "cantidad='" + cantidad + "', " : "") +
                ((moneda != null) ? "moneda=" + moneda + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MedioPago medioPago = (MedioPago) o;
        return Objects.equals(id, medioPago.id) && Objects.equals(descripcion, medioPago.descripcion) && Objects.equals(importe, medioPago.importe) && Objects.equals(porcentaje, medioPago.porcentaje) && Objects.equals(cantidad, medioPago.cantidad) && Objects.equals(moneda, medioPago.moneda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, descripcion, importe, porcentaje, cantidad, moneda);
    }
}