/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.util;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SimpleCache<K, V> {
    private final Map<K, V> cacheMap;
    private final Function<K, V> valueLoader;
    private final ReentrantReadWriteLock rwl;
    private final DelayQueue<DelayedKey<K>> delayQueue;
    private final Map<K, DelayedKey<K>> expiringKeys;
    private final long defaultExpiryAfter;
    private final TemporalUnit defaultExpiryUnit;

    private SimpleCache(Map<K, V> cacheMap, Function<K, V> valueLoader, long defaultExpiryAfter, TemporalUnit defaultExpiryUnit) {
        this.cacheMap = cacheMap;
        this.valueLoader = valueLoader;
        this.rwl = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.expiringKeys = new HashMap<K, DelayedKey<K>>();
        this.defaultExpiryAfter = defaultExpiryAfter;
        this.defaultExpiryUnit = defaultExpiryUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        this.rwl.writeLock().lock();
        try {
            this.doCleanup();
            V v = this.internalPutValue(key, value);
            return v;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.putIfAbsent(key, () -> value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, Supplier<V> valueSupplier) {
        Objects.requireNonNull(key);
        this.rwl.readLock().lock();
        try {
            this.doCleanup();
            V value = this.cacheMap.get(key);
            if (value == null && valueSupplier != null) {
                this.rwl.readLock().unlock();
                this.rwl.writeLock().lock();
                try {
                    value = this.cacheMap.get(key);
                    if (value == null) {
                        value = valueSupplier.get();
                        this.internalPutValue(key, value);
                    }
                }
                finally {
                    this.rwl.readLock().lock();
                    this.rwl.writeLock().unlock();
                }
            }
            V v = value;
            return v;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public V getIfPresent(K key) {
        return this.doGetValue(key, false);
    }

    public V get(K key) {
        return this.doGetValue(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private V doGetValue(K key, boolean loadIfAbsent) {
        Objects.requireNonNull(key);
        this.rwl.readLock().lock();
        try {
            this.doCleanup();
            value = this.cacheMap.get(key);
            if (value == null && loadIfAbsent && this.valueLoader != null) {
                this.rwl.readLock().unlock();
                this.rwl.writeLock().lock();
                try {
                    value = this.cacheMap.get(key);
                    if (value != null) ** GOTO lbl23
                    value = this.valueLoader.apply(key);
                    this.internalPutValue(key, value);
                }
                finally {
                    this.rwl.readLock().lock();
                    this.rwl.writeLock().unlock();
                }
            } else {
                this.renewKey(key);
            }
lbl23:
            // 3 sources

            var4_5 = value;
            return var4_5;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private V internalPutValue(K key, V value) {
        if (this.defaultExpiryAfter > 0L) {
            DelayedKey<K> delayedKey = new DelayedKey<K>(key, this.defaultExpiryAfter, this.defaultExpiryUnit);
            DelayedKey<K> oldKey = this.expiringKeys.put(key, delayedKey);
            if (oldKey != null) {
                this.delayQueue.remove(oldKey);
            }
            this.delayQueue.offer(delayedKey);
        }
        return this.cacheMap.put(key, value);
    }

    public V remove(K key) {
        Objects.requireNonNull(key);
        this.rwl.writeLock().lock();
        try {
            this.doCleanup();
            this.delayQueue.remove(new DelayedKey<K>(key));
            this.expiringKeys.remove(key);
            V v = this.cacheMap.remove(key);
            return v;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void clear() {
        this.rwl.writeLock().lock();
        try {
            this.cacheMap.clear();
            this.delayQueue.clear();
            this.expiringKeys.clear();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public long size() {
        this.cleanup();
        return this.cacheMap.size();
    }

    public boolean renewKey(K key) {
        DelayedKey<K> delayedKey = this.expiringKeys.get(key);
        if (delayedKey != null) {
            delayedKey.renew();
            return true;
        }
        return false;
    }

    public void cleanup() {
        this.rwl.writeLock().lock();
        try {
            this.doCleanup();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private void doCleanup() {
        DelayedKey delayedKey = (DelayedKey)this.delayQueue.poll();
        while (delayedKey != null) {
            this.cacheMap.remove(delayedKey.getKey());
            this.expiringKeys.remove(delayedKey.getKey());
            delayedKey = (DelayedKey)this.delayQueue.poll();
        }
    }

    public static <K, V> CacheBuilder<K, V> builder() {
        return new CacheBuilder();
    }

    private static class DelayedKey<K>
    implements Delayed {
        private final K key;
        private long expireAfter;
        private TemporalUnit expiryUnit;
        private Instant startTime;

        public DelayedKey(K key) {
            this.key = key;
        }

        public DelayedKey(K key, long expireAfter, TemporalUnit expiryUnit) {
            this(key);
            this.expiryUnit = expiryUnit;
            this.startTime = Instant.now();
            this.expireAfter = expireAfter;
        }

        public K getKey() {
            return this.key;
        }

        public void renew() {
            this.startTime = Instant.now();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            long diff = this.startTime == null ? 0L : Duration.between(Instant.now(), this.startTime.plus(this.expireAfter, this.expiryUnit)).toMillis();
            return timeUnit.convert(diff, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed that) {
            return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), that.getDelay(TimeUnit.NANOSECONDS));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.key.equals(((DelayedKey)o).key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static final class CacheBuilder<K, V> {
        private int initialCapacity = -1;
        private long maximumSize = -1L;
        private long defaultExpiryAfter = 0L;
        private TemporalUnit defaultExpiryUnit;

        public CacheBuilder<K, V> initialCapacity(int initialCapacity) throws IllegalArgumentException {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("initialCapacity should be >= 0");
            }
            this.initialCapacity = initialCapacity;
            return this;
        }

        public CacheBuilder<K, V> maximumSize(long maximumSize) throws IllegalArgumentException {
            if (maximumSize <= 0L) {
                throw new IllegalArgumentException("maximumSize should be greater than zero");
            }
            this.maximumSize = maximumSize;
            return this;
        }

        public CacheBuilder<K, V> expireAfter(long expiryAfter, TemporalUnit expiryUnit) throws IllegalArgumentException {
            if (expiryAfter <= 0L) {
                throw new IllegalArgumentException("value for expiryAfter should be greater than zero");
            }
            this.defaultExpiryAfter = expiryAfter;
            this.defaultExpiryUnit = Objects.requireNonNull(expiryUnit);
            return this;
        }

        public <K1 extends K, V1 extends V> SimpleCache<K1, V1> build() {
            return this.build(null);
        }

        public <K1 extends K, V1 extends V> SimpleCache<K1, V1> build(Function<K1, V1> valueLoader) {
            this.initialCapacity = Math.max(this.initialCapacity, 0);
            LinkedHashMap cacheMap = this.maximumSize > 0L ? new LinkedHashMap<K1, V1>(this.initialCapacity, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K1, V1> eldest) {
                    return (long)this.size() > maximumSize;
                }
            } : new LinkedHashMap(this.initialCapacity);
            return new SimpleCache<K1, V1>(cacheMap, valueLoader, this.defaultExpiryAfter, this.defaultExpiryUnit);
        }
    }
}

