package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cobro implements Serializable {

    @JsonProperty("fechaCobro")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaCobro;

    @JsonProperty("fechaVencimiento")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaVencimiento;

    @JsonProperty("numeroRecaudacion")
    private String numeroRecaudacion;

    @JsonProperty("sucursalRecaudacion")
    private String sucursalRecaudacion;

    @JsonProperty("formaCobro")
    private String formaCobro;

    @JsonProperty("importeRecaudado")
    private BigDecimal importeRecaudado;

    @JsonProperty("importeAcreditado")
    private BigDecimal importeAcreditado;

    @JsonProperty("importeRechazado")
    private BigDecimal importeRechazado;

    @JsonProperty("efectivo")
    private BigDecimal efectivo;

    @JsonProperty("chequesAlDia")
    private BigDecimal chequesAlDia;

    @JsonProperty("chequePagoDife")
    private BigDecimal chequePagoDife;

    @JsonProperty("estadoCobranza")
    private String estadoCobranza;

    @JsonProperty("referencia")
    private Referencia referencia;

    @JsonProperty("notaCredito")
    private BigDecimal notaCredito;

    @JsonProperty("certificacionRetencion")
    private BigDecimal certificacionRetencion;

    @JsonProperty("importePublicado")
    private BigDecimal importePublicado;

    @JsonProperty("importeAdeudado")
    private BigDecimal importeAdeudado;

    @JsonProperty("moneda")
    private Moneda moneda;

    @JsonProperty("importeTransferencia")
    private BigDecimal importeTransferencia;

    public Date getFechaCobro() {
        return fechaCobro;
    }

    public void setFechaCobro(Date fechaCobro) {
        this.fechaCobro = fechaCobro;
    }

    public Date getFechaVencimiento() {
        return fechaVencimiento;
    }

    public void setFechaVencimiento(Date fechaVencimiento) {
        this.fechaVencimiento = fechaVencimiento;
    }

    public String getNumeroRecaudacion() {
        return numeroRecaudacion;
    }

    public void setNumeroRecaudacion(String numeroRecaudacion) {
        this.numeroRecaudacion = numeroRecaudacion;
    }

    public String getSucursalRecaudacion() {
        return sucursalRecaudacion;
    }

    public void setSucursalRecaudacion(String sucursalRecaudacion) {
        this.sucursalRecaudacion = sucursalRecaudacion;
    }

    public String getFormaCobro() {
        return formaCobro;
    }

    public void setFormaCobro(String formaCobro) {
        this.formaCobro = formaCobro;
    }

    public BigDecimal getImporteRecaudado() {
        return importeRecaudado;
    }

    public void setImporteRecaudado(String importeRecaudado) {
        this.importeRecaudado = stringAmountToBigDecimal(importeRecaudado);
    }

    public BigDecimal getImporteAcreditado() {
        return importeAcreditado;
    }

    public void setImporteAcreditado(String importeAcreditado) {
        this.importeAcreditado = stringAmountToBigDecimal(importeAcreditado);
    }

    public BigDecimal getImporteRechazado() {
        return importeRechazado;
    }

    public void setImporteRechazado(String importeRechazado) {
        this.importeRechazado = stringAmountToBigDecimal(importeRechazado);
    }

    public BigDecimal getEfectivo() {
        return efectivo;
    }

    public void setEfectivo(String efectivo) {
        this.efectivo = stringAmountToBigDecimal(efectivo);
    }

    public BigDecimal getChequesAlDia() {
        return chequesAlDia;
    }

    public void setChequesAlDia(String chequesAlDia) {
        this.chequesAlDia = stringAmountToBigDecimal(chequesAlDia);
    }

    public BigDecimal getChequePagoDife() {
        return chequePagoDife;
    }

    public void setChequePagoDife(String chequePagoDife) {
        this.chequePagoDife = stringAmountToBigDecimal(chequePagoDife);
    }

    public String getEstadoCobranza() {
        return estadoCobranza;
    }

    public void setEstadoCobranza(String estadoCobranza) {
        this.estadoCobranza = estadoCobranza;
    }

    public Referencia getReferencia() {
        return referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referencia = referencia;
    }

    public BigDecimal getNotaCredito() {
        return notaCredito;
    }

    public void setNotaCredito(String notaCredito) {
        this.notaCredito = stringAmountToBigDecimal(notaCredito);
    }

    public BigDecimal getCertificacionRetencion() {
        return certificacionRetencion;
    }

    public void setCertificacionRetencion(String certificacionRetencion) {
        this.certificacionRetencion = stringAmountToBigDecimal(certificacionRetencion);
    }

    public BigDecimal getImportePublicado() {
        return importePublicado;
    }

    public void setImportePublicado(String importePublicado) {
        this.importePublicado = stringAmountToBigDecimal(importePublicado);
    }

    public BigDecimal getImporteAdeudado() {
        return importeAdeudado;
    }

    public void setImporteAdeudado(String importeAdeudado) {
        this.importeAdeudado = stringAmountToBigDecimal(importeAdeudado);
    }

    public Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(Moneda moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporteTransferencia() {
        return importeTransferencia;
    }

    public void setImporteTransferencia(String importeTransferencia) {
        this.importeTransferencia = stringAmountToBigDecimal(importeTransferencia);
    }

    @Override
    public String toString() {
        return "Cobro [" +
                ((fechaCobro != null) ? "fechaCobro=" + fechaCobro + ", " : "") +
                ((fechaVencimiento != null) ? "fechaVencimiento=" + fechaVencimiento + ", " : "") +
                ((numeroRecaudacion != null) ? "numeroRecaudacion='" + numeroRecaudacion + "', " : "") +
                ((sucursalRecaudacion != null) ? "sucursalRecaudacion='" + sucursalRecaudacion + "', " : "") +
                ((formaCobro != null) ? "formaCobro='" + formaCobro + "', " : "") +
                ((importeRecaudado != null) ? "importeRecaudado=" + importeRecaudado + ", " : "") +
                ((importeAcreditado != null) ? "importeAcreditado=" + importeAcreditado + ", " : "") +
                ((importeRechazado != null) ? "importeRechazado=" + importeRechazado + ", " : "") +
                ((efectivo != null) ? "efectivo=" + efectivo + ", " : "") +
                ((chequesAlDia != null) ? "chequesAlDia=" + chequesAlDia + ", " : "") +
                ((chequePagoDife != null) ? "chequePagoDife=" + chequePagoDife + ", " : "") +
                ((estadoCobranza != null) ? "estadoCobranza='" + estadoCobranza + "', " : "") +
                ((referencia != null) ? "referencia=" + referencia + ", " : "") +
                ((notaCredito != null) ? "notaCredito=" + notaCredito + ", " : "") +
                ((certificacionRetencion != null) ? "certificacionRetencion=" + certificacionRetencion + ", " : "") +
                ((importePublicado != null) ? "importePublicado=" + importePublicado + ", " : "") +
                ((importeAdeudado != null) ? "importeAdeudado=" + importeAdeudado + ", " : "") +
                ((moneda != null) ? "moneda=" + moneda + ", " : "") +
                ((importeTransferencia != null) ? "importeTransferencia=" + importeTransferencia + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cobro cobro = (Cobro) o;
        return Objects.equals(fechaCobro, cobro.fechaCobro) && Objects.equals(fechaVencimiento, cobro.fechaVencimiento) && Objects.equals(numeroRecaudacion, cobro.numeroRecaudacion) && Objects.equals(sucursalRecaudacion, cobro.sucursalRecaudacion) && Objects.equals(formaCobro, cobro.formaCobro) && Objects.equals(importeRecaudado, cobro.importeRecaudado) && Objects.equals(importeAcreditado, cobro.importeAcreditado) && Objects.equals(importeRechazado, cobro.importeRechazado) && Objects.equals(efectivo, cobro.efectivo) && Objects.equals(chequesAlDia, cobro.chequesAlDia) && Objects.equals(chequePagoDife, cobro.chequePagoDife) && Objects.equals(estadoCobranza, cobro.estadoCobranza) && Objects.equals(referencia, cobro.referencia) && Objects.equals(notaCredito, cobro.notaCredito) && Objects.equals(certificacionRetencion, cobro.certificacionRetencion) && Objects.equals(importePublicado, cobro.importePublicado) && Objects.equals(importeAdeudado, cobro.importeAdeudado) && Objects.equals(moneda, cobro.moneda) && Objects.equals(importeTransferencia, cobro.importeTransferencia);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fechaCobro, fechaVencimiento, numeroRecaudacion, sucursalRecaudacion, formaCobro, importeRecaudado, importeAcreditado, importeRechazado, efectivo, chequesAlDia, chequePagoDife, estadoCobranza, referencia, notaCredito, certificacionRetencion, importePublicado, importeAdeudado, moneda, importeTransferencia);
    }

    private BigDecimal stringAmountToBigDecimal(String amount) {
        if (amount == null) {
            return null;
        }

        char decimalSep = amount.charAt(amount.length() - 3);
        if (decimalSep == ',') {
            amount = amount.replace(".", "").replace(",", ".");
        } else if (decimalSep == '.') {
            amount = amount.replace(",", ".");
        } else {
            // Es un numero entero, saco todos los . y ,
            amount = amount.replace(".", "").replace(",", "");
        }

        return new BigDecimal(amount);
    }
}