package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ArchivoPagos implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("estado")
    private Estado estado;

    @JsonProperty("fechaGeneracion")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMddHHmmssSSSZZZZ", timezone = "GMT-03:00")
    private Date fechaGeneracion;

    @JsonProperty("tipoArchivo")
    private TipoArchivo tipoArchivo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Date getFechaGeneracion() {
        return fechaGeneracion;
    }

    public void setFechaGeneracion(Date fechaGeneracion) {
        this.fechaGeneracion = fechaGeneracion;
    }

    public TipoArchivo getTipoArchivo() {
        return tipoArchivo;
    }

    public void setTipoArchivo(TipoArchivo tipoArchivo) {
        this.tipoArchivo = tipoArchivo;
    }

    @Override
    public String toString() {
        return "ArchivoPagos [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((estado != null) ? "estado=" + estado + ", " : "") +
                ((fechaGeneracion != null) ? "fechaGeneracion=" + fechaGeneracion + ", " : "") +
                ((tipoArchivo != null) ? "tipoArchivo=" + tipoArchivo + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ArchivoPagos archivo = (ArchivoPagos) o;
        return Objects.equals(id, archivo.id) && Objects.equals(estado, archivo.estado) && Objects.equals(fechaGeneracion, archivo.fechaGeneracion) && Objects.equals(tipoArchivo, archivo.tipoArchivo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, estado, fechaGeneracion, tipoArchivo);
    }
}