package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ChequeCobros implements Serializable {

    @JsonProperty("numero")
    private String numero;

    @JsonProperty("estado")
    private String estado;

    @JsonProperty("banco")
    private String banco;

    @JsonProperty("codigoPostal")
    private String codigoPostal;

    @JsonProperty("importe")
    private BigDecimal importe;

    @JsonProperty("cuenta")
    private String cuenta;

    @JsonProperty("fechaRecaudacion")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaRecaudacion;

    @JsonProperty("sucursal")
    private String sucursal;

    @JsonProperty("moneda")
    private String moneda;

    @JsonProperty("nroRecaudacion")
    private String nroRecaudacion;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaAcreditacion;

    public String getNumero() {
        return numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getCodigoPostal() {
        return codigoPostal;
    }

    public void setCodigoPostal(String codigoPostal) {
        this.codigoPostal = codigoPostal;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getCuenta() {
        return cuenta;
    }

    public void setCuenta(String cuenta) {
        this.cuenta = cuenta;
    }

    public Date getFechaRecaudacion() {
        return fechaRecaudacion;
    }

    public void setFechaRecaudacion(Date fechaRecaudacion) {
        this.fechaRecaudacion = fechaRecaudacion;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public String getNroRecaudacion() {
        return nroRecaudacion;
    }

    public void setNroRecaudacion(String nroRecaudacion) {
        this.nroRecaudacion = nroRecaudacion;
    }

    public Date getFechaAcreditacion() {
        return fechaAcreditacion;
    }

    public void setFechaAcreditacion(Date fechaAcreditacion) {
        this.fechaAcreditacion = fechaAcreditacion;
    }

    @Override
    public String toString() {
        return "ChequeCobros [" +
                ((numero != null) ? "numero='" + numero + "', " : "") +
                ((estado != null) ? "estado='" + estado + "', " : "") +
                ((banco != null) ? "banco='" + banco + "', " : "") +
                ((codigoPostal != null) ? "codigoPostal='" + codigoPostal + "', " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((cuenta != null) ? "cuenta='" + cuenta + "', " : "") +
                ((fechaRecaudacion != null) ? "fechaRecaudacion=" + fechaRecaudacion + ", " : "") +
                ((sucursal != null) ? "sucursal='" + sucursal + "', " : "") +
                ((moneda != null) ? "moneda='" + moneda + "', " : "") +
                ((nroRecaudacion != null) ? "nroRecaudacion='" + nroRecaudacion + "', " : "") +
                ((fechaAcreditacion != null) ? "fechaAcreditacion=" + fechaAcreditacion + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ChequeCobros that = (ChequeCobros) o;
        return Objects.equals(numero, that.numero) && Objects.equals(estado, that.estado) && Objects.equals(banco, that.banco) && Objects.equals(codigoPostal, that.codigoPostal) && Objects.equals(importe, that.importe) && Objects.equals(cuenta, that.cuenta) && Objects.equals(fechaRecaudacion, that.fechaRecaudacion) && Objects.equals(sucursal, that.sucursal) && Objects.equals(moneda, that.moneda) && Objects.equals(nroRecaudacion, that.nroRecaudacion) && Objects.equals(fechaAcreditacion, that.fechaAcreditacion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numero, estado, banco, codigoPostal, importe, cuenta, fechaRecaudacion, sucursal, moneda, nroRecaudacion, fechaAcreditacion);
    }
}