package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ChequePagosTotalizer implements Serializable {

    @JsonProperty("cantidadSinImprimir")
    private Long cantidadSinImprimir;

    @JsonProperty("cantidadTotal")
    private Long cantidadTotal;

    public Long getCantidadSinImprimir() {
        return cantidadSinImprimir;
    }

    public void setCantidadSinImprimir(Long cantidadSinImprimir) {
        this.cantidadSinImprimir = cantidadSinImprimir;
    }

    public Long getCantidadTotal() {
        return cantidadTotal;
    }

    public void setCantidadTotal(Long cantidadTotal) {
        this.cantidadTotal = cantidadTotal;
    }

    @Override
    public String toString() {
        return "ChequePagosTotalizer [" +
                ((cantidadSinImprimir != null) ? "cantidadSinImprimir=" + cantidadSinImprimir + ", " : "") +
                ((cantidadTotal != null) ? "cantidadTotal=" + cantidadTotal + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ChequePagosTotalizer that = (ChequePagosTotalizer) o;
        return Objects.equals(cantidadSinImprimir, that.cantidadSinImprimir) && Objects.equals(cantidadTotal, that.cantidadTotal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cantidadSinImprimir, cantidadTotal);
    }
}