package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Importe implements Serializable {

    @JsonProperty("anteriorHoy")
    private BigDecimal anteriorHoy;

    @JsonProperty("hoy")
    private BigDecimal hoy;

    @JsonProperty("hoyMasUnDia")
    private BigDecimal hoyMasUnDia;

    @JsonProperty("hoyMasDosDias")
    private BigDecimal hoyMasDosDias;

    @JsonProperty("hoyMasTresDias")
    private BigDecimal hoyMasTresDias;

    @JsonProperty("hoyMasCuatroDias")
    private BigDecimal hoyMasCuatroDias;

    @JsonProperty("mayorCincoDias")
    private BigDecimal mayorCincoDias;

    public BigDecimal getAnteriorHoy() {
        return anteriorHoy;
    }

    public void setAnteriorHoy(BigDecimal anteriorHoy) {
        this.anteriorHoy = anteriorHoy;
    }

    public BigDecimal getHoy() {
        return hoy;
    }

    public void setHoy(BigDecimal hoy) {
        this.hoy = hoy;
    }

    public BigDecimal getHoyMasUnDia() {
        return hoyMasUnDia;
    }

    public void setHoyMasUnDia(BigDecimal hoyMasUnDia) {
        this.hoyMasUnDia = hoyMasUnDia;
    }

    public BigDecimal getHoyMasDosDias() {
        return hoyMasDosDias;
    }

    public void setHoyMasDosDias(BigDecimal hoyMasDosDias) {
        this.hoyMasDosDias = hoyMasDosDias;
    }

    public BigDecimal getHoyMasTresDias() {
        return hoyMasTresDias;
    }

    public void setHoyMasTresDias(BigDecimal hoyMasTresDias) {
        this.hoyMasTresDias = hoyMasTresDias;
    }

    public BigDecimal getHoyMasCuatroDias() {
        return hoyMasCuatroDias;
    }

    public void setHoyMasCuatroDias(BigDecimal hoyMasCuatroDias) {
        this.hoyMasCuatroDias = hoyMasCuatroDias;
    }

    public BigDecimal getMayorCincoDias() {
        return mayorCincoDias;
    }

    public void setMayorCincoDias(BigDecimal mayorCincoDias) {
        this.mayorCincoDias = mayorCincoDias;
    }

    @Override
    public String toString() {
        return "Importe [" +
                ((anteriorHoy != null) ? "anteriorHoy=" + anteriorHoy + ", " : "") +
                ((hoy != null) ? "hoy=" + hoy + ", " : "") +
                ((hoyMasUnDia != null) ? "hoyMasUnDia=" + hoyMasUnDia + ", " : "") +
                ((hoyMasDosDias != null) ? "hoyMasDosDias=" + hoyMasDosDias + ", " : "") +
                ((hoyMasTresDias != null) ? "hoyMasTresDias=" + hoyMasTresDias + ", " : "") +
                ((hoyMasCuatroDias != null) ? "hoyMasCuatroDias=" + hoyMasCuatroDias + ", " : "") +
                ((mayorCincoDias != null) ? "mayorCincoDias=" + mayorCincoDias + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Importe importe = (Importe) o;
        return Objects.equals(anteriorHoy, importe.anteriorHoy) && Objects.equals(hoy, importe.hoy) && Objects.equals(hoyMasUnDia, importe.hoyMasUnDia) && Objects.equals(hoyMasDosDias, importe.hoyMasDosDias) && Objects.equals(hoyMasTresDias, importe.hoyMasTresDias) && Objects.equals(hoyMasCuatroDias, importe.hoyMasCuatroDias) && Objects.equals(mayorCincoDias, importe.mayorCincoDias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(anteriorHoy, hoy, hoyMasUnDia, hoyMasDosDias, hoyMasTresDias, hoyMasCuatroDias, mayorCincoDias);
    }
}