package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Recaudacion implements Serializable {

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("monto")
    private String monto;

    @JsonProperty("canal")
    private String canal;

    @JsonProperty("numeroConsulta")
    private String numeroConsulta;

    @JsonProperty("moneda")
    private Moneda moneda;

    @JsonProperty("listaCobros")
    private List<ListaCobros> listaCobros;

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getMonto() {
        return monto;
    }

    public void setMonto(String monto) {
        this.monto = monto;
    }

    public String getCanal() {
        return canal;
    }

    public void setCanal(String canal) {
        this.canal = canal;
    }

    public String getNumeroConsulta() {
        return numeroConsulta;
    }

    public void setNumeroConsulta(String numeroConsulta) {
        this.numeroConsulta = numeroConsulta;
    }

    public Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(Moneda moneda) {
        this.moneda = moneda;
    }

    public List<ListaCobros> getListaCobros() {
        return listaCobros;
    }

    public void setListaCobros(List<ListaCobros> listaCobros) {
        this.listaCobros = listaCobros;
    }

    @Override
    public String toString() {
        return "Recaudacion{" +
                "descripcion='" + descripcion + '\'' +
                ", monto='" + monto + '\'' +
                ", canal='" + canal + '\'' +
                ", numeroConsulta='" + numeroConsulta + '\'' +
                ", moneda=" + moneda +
                ", listaCobros=" + listaCobros +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Recaudacion that = (Recaudacion) o;
        return Objects.equals(descripcion, that.descripcion) && Objects.equals(monto, that.monto) && Objects.equals(canal, that.canal) && Objects.equals(numeroConsulta, that.numeroConsulta) && Objects.equals(moneda, that.moneda) && Objects.equals(listaCobros, that.listaCobros);
    }

    @Override
    public int hashCode() {
        return Objects.hash(descripcion, monto, canal, numeroConsulta, moneda, listaCobros);
    }
}