package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaCobroDetalleResponse extends CommonResponse implements Serializable {

    @JsonProperty("medioPagoLista")
    private List<MedioPago> medioPago;

    @JsonProperty("recaudacionLista")
    private List<Recaudacion> recaudacion;

    @JsonProperty("resumenLista")
    private List<Resumen> resumen;

    @JsonProperty("cobroLista")
    private List<Cobro> cobros;

    @JsonProperty("pagina")
    private Pagina pagina;

    public List<MedioPago> getMedioPago() {
        return medioPago;
    }

    public void setMedioPago(List<MedioPago> medioPago) {
        this.medioPago = medioPago;
    }

    public List<Recaudacion> getRecaudacion() {
        return recaudacion;
    }

    public void setRecaudacion(List<Recaudacion> recaudacion) {
        this.recaudacion = recaudacion;
    }

    public List<Resumen> getResumen() {
        return resumen;
    }

    public void setResumen(List<Resumen> resumen) {
        this.resumen = resumen;
    }

    public Pagina getPagina() {
        return pagina;
    }

    public void setPagina(Pagina pagina) {
        this.pagina = pagina;
    }

    public List<Cobro> getCobros() {
        return cobros;
    }

    public void setCobros(List<Cobro> cobros) {
        this.cobros = cobros;
    }

    @Override
    public String toString() {
        return "EmpresaCobroDetalleResponse [" +
                ((medioPago != null) ? "medioPago=" + Arrays.toString(medioPago.toArray()) + ", " : "") +
                ((recaudacion != null) ? "recaudacion=" + Arrays.toString(recaudacion.toArray()) + ", " : "") +
                ((resumen != null) ? "resumen=" + Arrays.toString(resumen.toArray()) + ", " : "") +
                ((cobros != null) ? "cobros=" + Arrays.toString(cobros.toArray()) + ", " : "") +
                ((pagina != null) ? "pagina=" + pagina + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaCobroDetalleResponse that = (EmpresaCobroDetalleResponse) o;
        return Objects.equals(medioPago, that.medioPago) && Objects.equals(recaudacion, that.recaudacion) && Objects.equals(resumen, that.resumen) && Objects.equals(cobros, that.cobros) && Objects.equals(pagina, that.pagina);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), medioPago, recaudacion, resumen, cobros, pagina);
    }
}