package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErrorResponse implements Serializable {

    @JsonProperty("estadoEjecucion")
    private String estadoEjecucion;

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("error")
    private Error error;

    public String getEstadoEjecucion() {
        return estadoEjecucion;
    }

    public void setEstadoEjecucion(String estadoEjecucion) {
        this.estadoEjecucion = estadoEjecucion;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public Error getError() {
        return error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    @Override
    public String toString() {
        return "ErrorResponse [" +
                ((estadoEjecucion != null) ? "estadoEjecucion='" + estadoEjecucion + "', " : "") +
                ((descripcion != null) ? "descripcion='" + descripcion + "', " : "") +
                ((error != null) ? "error=" + error + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErrorResponse that = (ErrorResponse) o;
        return Objects.equals(estadoEjecucion, that.estadoEjecucion) && Objects.equals(descripcion, that.descripcion) && Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(estadoEjecucion, descripcion, error);
    }
}