package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class HistorialEstado implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("eventoLista")
    private List<Evento> eventos;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public List<Evento> getEventos() {
        return eventos;
    }

    public void setEventos(List<Evento> eventos) {
        this.eventos = eventos;
    }

    @Override
    public String toString() {
        return "HistorialEstado [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((descripcion != null) ? "descripcion='" + descripcion + "', " : "") +
                ((eventos != null) ? "eventos=" + Arrays.toString(eventos.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HistorialEstado that = (HistorialEstado) o;
        return Objects.equals(id, that.id) && Objects.equals(descripcion, that.descripcion) && Objects.equals(eventos, that.eventos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, descripcion, eventos);
    }
}