package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Usuario implements Serializable {

    @JsonProperty("alias")
    private String alias;

    @JsonProperty("uriOperador")
    private String uriOperador;

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getUriOperador() {
        return uriOperador;
    }

    public void setUriOperador(String uriOperador) {
        this.uriOperador = uriOperador;
    }

    @Override
    public String toString() {
        return "Usuario{" +
                "alias='" + alias + '\'' +
                ", uriOperador='" + uriOperador + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Usuario usuario = (Usuario) o;
        return Objects.equals(alias, usuario.alias) && Objects.equals(uriOperador, usuario.uriOperador);
    }

    @Override
    public int hashCode() {
        return Objects.hash(alias, uriOperador);
    }
}