/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorBase;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoErroresResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoEstadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoSubidoDescargaResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivosDevolucionResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroArchivoEstadoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaCuentasResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaOrdenPagoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaPagoDetalleResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaPagoListadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaPagosHistoricosResponse;
import ar.com.sdd.patagoniaapi.model.EmpresaChequeEstadoDetalladoResponse;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import java.math.BigDecimal;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatagoniaApiPagosConnector
extends PatagoniaApiConnectorBase {
    private static final Logger log = LogManager.getLogger(PatagoniaApiPagosConnector.class);

    public PatagoniaApiPagosConnector(PatagoniaApiConnectorContext context) {
        super(context);
    }

    public EmpresaArchivoEstadoResponse publicarOrdenesDePago(String fileName, String fileInBase64) throws RestConnectorException {
        return this.uploadFile(fileName, fileInBase64);
    }

    @Override
    public EmpresaArchivoEstadoResponse confirmarOperacion(String token, String fileName) throws RestConnectorException {
        log.debug("[confirmarOperacion] Por confirmar procesamiento del archivo " + fileName);
        String tipoArchivo = fileName.substring(0, 2);
        EmpresaCobroArchivoEstadoRequest empresaCobroArchivoEstadoRequest = new EmpresaCobroArchivoEstadoRequest();
        empresaCobroArchivoEstadoRequest.setToken(token);
        String subconvenio = "1";
        String path = "/archivo/estado/prod/" + this.docProd + "/adherentes/" + this.adherente + "/tipo-arch/" + tipoArchivo + "/doc-tp/" + this.documentoTipo + "/docNum/" + this.documentoNumero + "/ch/PT";
        return (EmpresaArchivoEstadoResponse)this.restConnector.genericPost((Object)empresaCobroArchivoEstadoRequest, EmpresaArchivoEstadoResponse.class, ErrorResponse.class, path);
    }

    public EmpresaPagoListadoResponse consultaOrdenesDePago(Integer pagAct, Integer pagCant, String cbu, String ordenPagoReferencia, Date fechaEjecucionDesde, Date fechaEjecucionHasta, String referenciaClienteDesde, String referenciaClienteHasta, String nombreBeneficiario, String documentoBeneficiario, BigDecimal importeDesde, BigDecimal importeHasta, String paymentMethodIds, String paymentStatusIds) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/pago/prod/" + this.docProd + "/adherentes/" + this.adherente + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        if (cbu != null && !cbu.isEmpty()) {
            path = path + "&cbu=" + cbu;
        }
        if (ordenPagoReferencia != null && !ordenPagoReferencia.isEmpty()) {
            path = path + "&ref-cli=" + ordenPagoReferencia;
        }
        if (fechaEjecucionDesde != null) {
            path = path + "&fec-eje-dsd=" + this.sdf.format(fechaEjecucionDesde);
        }
        if (fechaEjecucionHasta != null) {
            path = path + "&fec-eje-hst=" + this.sdf.format(fechaEjecucionHasta);
        }
        if (referenciaClienteDesde != null && !referenciaClienteDesde.isEmpty()) {
            path = path + "&ref-cli-dsd=" + referenciaClienteDesde;
        }
        if (referenciaClienteHasta != null && !referenciaClienteHasta.isEmpty()) {
            path = path + "&ref-cli-hst=" + referenciaClienteHasta;
        }
        if (nombreBeneficiario != null && !nombreBeneficiario.isEmpty()) {
            path = path + "&benef-denom=" + nombreBeneficiario;
        }
        if (documentoBeneficiario != null && !documentoBeneficiario.isEmpty()) {
            path = path + "&benef-doc=" + documentoBeneficiario;
        }
        if (importeDesde != null) {
            path = path + "&importe-dsd=" + importeDesde;
        }
        if (importeHasta != null) {
            path = path + "&importe-hst=" + importeHasta;
        }
        if (paymentMethodIds != null && !paymentMethodIds.isEmpty()) {
            path = path + "&pag-met-id=" + paymentMethodIds;
        }
        if (paymentStatusIds != null && !paymentStatusIds.isEmpty()) {
            path = path + "&pag-std-id=" + paymentStatusIds;
        }
        Pair response = this.restConnector.genericGetWithResponseHeader(null, EmpresaPagoListadoResponse.class, ErrorResponse.class, path, null);
        this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)response.getValue()));
        return (EmpresaPagoListadoResponse)response.getKey();
    }

    public EmpresaPagoDetalleResponse consultaDetallesDeOrdenDePago(long operacionId, Long subOperacionId) throws RestConnectorException {
        String path = "/pago/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + operacionId;
        if (subOperacionId != null) {
            path = path + "/" + subOperacionId;
        }
        path = path + "/ch/PT";
        return (EmpresaPagoDetalleResponse)this.restConnector.genericGet(null, EmpresaPagoDetalleResponse.class, ErrorResponse.class, path);
    }

    public EmpresaChequeEstadoDetalladoResponse consultaCheques(Integer pagAct, Integer pagCant, String cuenta, String numeroChequeDesde, String numeroChequeHasta, String nombreBeneficiario, String documentoBeneficiario, BigDecimal importeDesde, BigDecimal importeHasta, String paymentStatusIds) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/pago/prod/" + this.docProd + "/adherentes/" + this.adherente + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        if (cuenta != null && !cuenta.isEmpty()) {
            path = path + "&cuenta=" + cuenta;
        }
        if (numeroChequeDesde != null) {
            path = path + "&id-dsd=" + this.sdf.format(numeroChequeDesde);
        }
        if (numeroChequeHasta != null) {
            path = path + "&id-hst=" + this.sdf.format(numeroChequeHasta);
        }
        if (nombreBeneficiario != null && !nombreBeneficiario.isEmpty()) {
            path = path + "&benef-denom=" + nombreBeneficiario;
        }
        if (documentoBeneficiario != null && !documentoBeneficiario.isEmpty()) {
            path = path + "&benef-doc=" + documentoBeneficiario;
        }
        if (importeDesde != null) {
            path = path + "&monto-dsd=" + importeDesde;
        }
        if (importeHasta != null) {
            path = path + "&monto-hst=" + importeHasta;
        }
        if (paymentStatusIds != null && !paymentStatusIds.isEmpty()) {
            path = path + "&lista-check=" + paymentStatusIds;
        }
        return (EmpresaChequeEstadoDetalladoResponse)this.restConnector.genericGet(null, EmpresaChequeEstadoDetalladoResponse.class, ErrorResponse.class, path);
    }

    public EmpresaPagosHistoricosResponse consultaEnvios(String archivoTipo, Integer pagAct, Integer pagCant, String nombreIngresante, String apellidoIngresante, Date fechaRecepcionDesde, Date fechaRecepcionHasta, String archivoEstado) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/pago/" + this.adherente + "/adherentes/pagos/archivoTipo/" + archivoTipo + "?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        if (nombreIngresante != null && !nombreIngresante.isEmpty()) {
            path = path + "&nom=" + nombreIngresante;
        }
        if (apellidoIngresante != null && !apellidoIngresante.isEmpty()) {
            path = path + "&ape=" + apellidoIngresante;
        }
        if (archivoEstado != null && !archivoEstado.isEmpty()) {
            path = path + "&archivo-estado=" + archivoEstado;
        }
        if (fechaRecepcionDesde != null) {
            path = path + "&fecha-dsd=" + this.sdf.format(fechaRecepcionDesde);
        }
        if (fechaRecepcionHasta != null) {
            path = path + "&fecha-hst=" + this.sdf.format(fechaRecepcionHasta);
        }
        return (EmpresaPagosHistoricosResponse)this.restConnector.genericGet(null, EmpresaPagosHistoricosResponse.class, ErrorResponse.class, path);
    }

    public EmpresaPagosHistoricosResponse consultaFlujoEgresos() throws RestConnectorException {
        String path = "/pago/egresos/cuit/" + this.docProd + "/adherente/" + this.adherente + "/ch/PT";
        return (EmpresaPagosHistoricosResponse)this.restConnector.genericGet(null, EmpresaPagosHistoricosResponse.class, ErrorResponse.class, path);
    }

    public EmpresaArchivoErroresResponse consultaErroresArchivo(String archivoId, int pagAct, int pagCant) throws RestConnectorException {
        String path = "/archivo/pagos/" + this.docProd + "/adherentes/" + this.adherente + "/errores-en-archivo/" + archivoId + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        return (EmpresaArchivoErroresResponse)this.restConnector.genericGet(null, EmpresaArchivoErroresResponse.class, ErrorResponse.class, path);
    }

    private EmpresaOrdenPagoResponse consultaContenidoArchivo(String archivoId, Integer pagAct, Integer pagCant) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/archivo/orden-pago/" + archivoId + "/prod/" + this.docProd + "/adherentes/" + this.adherente + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        return (EmpresaOrdenPagoResponse)this.restConnector.genericGet(null, EmpresaOrdenPagoResponse.class, ErrorResponse.class, path);
    }

    private EmpresaCuentasResponse consultaCuentasPagosCash(String archivoId, Integer pagAct, Integer pagCant) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/archivo/orden-pago/" + archivoId + "/prod/" + this.docProd + "/adherentes/" + this.adherente + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        return (EmpresaCuentasResponse)this.restConnector.genericGet(null, EmpresaCuentasResponse.class, ErrorResponse.class, path);
    }

    private EmpresaArchivosDevolucionResponse consultaRecepcionArchivo(Integer pagAct, Integer pagCant, String archivoTipo, String archivoEstado, Date fechaDesde, Date fechaHasta) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/archivo/devolucion/prod/" + this.docProd + "/adherentes/" + this.adherente + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        if (archivoTipo != null && !archivoTipo.isEmpty()) {
            path = path + "&archivo-tipo=" + archivoTipo;
        }
        if (archivoEstado != null && !archivoEstado.isEmpty()) {
            path = path + "&archivo-estado=" + archivoEstado;
        }
        if (fechaDesde != null) {
            path = path + "&fecha-dsd=" + this.sdf.format(fechaDesde);
        }
        if (fechaHasta != null) {
            path = path + "&fecha-hst=" + this.sdf.format(fechaHasta);
        }
        return (EmpresaArchivosDevolucionResponse)this.restConnector.genericGet(null, EmpresaArchivosDevolucionResponse.class, ErrorResponse.class, path);
    }

    private EmpresaArchivoSubidoDescargaResponse generarArchivo(String archivoId) throws RestConnectorException {
        String path = "/prod/" + this.docProd + "/adherentes/" + this.adherente + "archivos-rpocesado/" + archivoId + "/ch/PT";
        return (EmpresaArchivoSubidoDescargaResponse)this.restConnector.genericGet(null, EmpresaArchivoSubidoDescargaResponse.class, ErrorResponse.class, path);
    }

    private String descargarArchivo(String token) throws RestConnectorException {
        String path = "/archivo?" + token;
        return (String)this.restConnector.genericGet(null, String.class, ErrorResponse.class, path);
    }
}

