/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorBase;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.ConsultaArchivosRecepcionResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoEstadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoSubidoDescargaResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroArchivoEstadoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroChequesDetalleResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroDetalleResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaCobroListadoResponse;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatagoniaApiCobrosConnector
extends PatagoniaApiConnectorBase {
    private static final Logger log = LogManager.getLogger(PatagoniaApiCobrosConnector.class);

    public PatagoniaApiCobrosConnector(PatagoniaApiConnectorContext context) {
        super(context);
    }

    public EmpresaArchivoEstadoResponse publicarDeuda(String fileName, String fileInBase64) throws RestConnectorException {
        return this.uploadFile(fileName, fileInBase64);
    }

    @Override
    public EmpresaArchivoEstadoResponse confirmarOperacion(String token, String fileName) throws RestConnectorException {
        log.debug("[confirmarOperacion] Por confirmar procesamiento del archivo " + fileName);
        String tipoArchivo = fileName.substring(0, 2);
        EmpresaCobroArchivoEstadoRequest empresaCobroArchivoEstadoRequest = new EmpresaCobroArchivoEstadoRequest();
        empresaCobroArchivoEstadoRequest.setToken(token);
        String subconvenio = "1";
        String path = "/cobro/archivo/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/estado/tipo-arch/" + tipoArchivo + "/doc-tp/" + this.documentoTipo + "/docNum/" + this.documentoNumero + "/ch/PT";
        return (EmpresaArchivoEstadoResponse)this.restConnector.genericPost((Object)empresaCobroArchivoEstadoRequest, EmpresaArchivoEstadoResponse.class, ErrorResponse.class, path);
    }

    public void consultaConvenioPorAdherente() {
    }

    public EmpresaCobroListadoResponse consultarPosicionIntegralDeCobros(Date fromDate, Date toDate) throws RestConnectorException {
        int urlParamsSep = 63;
        String url = "/cobro/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/ch/PT";
        if (fromDate != null) {
            url = url + (char)urlParamsSep + "fch-rec-dsd=" + this.sdf.format(fromDate);
            urlParamsSep = 38;
        }
        if (toDate != null) {
            url = url + (char)urlParamsSep + "fch-rec-hst=" + this.sdf.format(toDate);
            urlParamsSep = 38;
        }
        Pair response = this.restConnector.genericGetWithResponseHeader(null, EmpresaCobroListadoResponse.class, ErrorResponse.class, url, null);
        this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)response.getValue()));
        return (EmpresaCobroListadoResponse)response.getKey();
    }

    public EmpresaCobroDetalleResponse consultarDetallePosicionIntegralDeCobros(String subconvenio, String numeroCanal, String numeroConsulta, Date fechaRecuperoDesde, Date fechaRecuperoHasta, String deudor1, String deudor2, String comprobante1, String comprobante2, String comprobante3, String comprobante4, String comprobante5, int pagCant, int pagAct) throws RestConnectorException {
        String url = "/cobro/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/" + subconvenio + "/canal/" + numeroCanal + "/consulta/" + numeroConsulta;
        url = url + "?pag-cant=" + pagCant;
        url = url + "&pag-act=" + pagAct;
        if (fechaRecuperoDesde != null) {
            url = url + "&fch-rec-dsd=" + this.sdf.format(fechaRecuperoDesde);
        }
        if (fechaRecuperoHasta != null) {
            url = url + "&fch-rec-hst=" + this.sdf.format(fechaRecuperoHasta);
        }
        if (StringUtils.isNotEmpty((CharSequence)deudor1)) {
            url = url + "&deudor1=" + deudor1;
        }
        if (StringUtils.isNotEmpty((CharSequence)deudor2)) {
            url = url + "&deudor2=" + deudor2;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante1)) {
            url = url + "&comprobante1=" + comprobante1;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante2)) {
            url = url + "&comprobante2=" + comprobante2;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante3)) {
            url = url + "&comprobante3=" + comprobante3;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante4)) {
            url = url + "&comprobante4=" + comprobante4;
        }
        if (StringUtils.isNotEmpty((CharSequence)comprobante5)) {
            url = url + "&comprobante5=" + comprobante5;
        }
        return (EmpresaCobroDetalleResponse)this.restConnector.genericGet(null, EmpresaCobroDetalleResponse.class, ErrorResponse.class, url);
    }

    public void historialPublicacionDeArchivos() {
    }

    public ConsultaArchivosRecepcionResponse consultaArchivosRecepcion(Date fechaDesde, Date fechaHasta, int pagCant, int pagAct) throws RestConnectorException {
        String subconvenio = "1";
        String path = "/cobro/archivo/devolucion/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/ch/PT";
        path = path + "?pag-cant=" + pagCant;
        path = path + "&pag-act=" + pagAct;
        if (fechaDesde != null) {
            path = path + "&fecha-dsd=" + this.sdf.format(fechaDesde);
        }
        if (fechaHasta != null) {
            path = path + "&fecha-hst=" + this.sdf.format(fechaHasta);
        }
        Pair response = this.restConnector.genericGetWithResponseHeader(null, ConsultaArchivosRecepcionResponse.class, ErrorResponse.class, path, null);
        this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)response.getValue()));
        return (ConsultaArchivosRecepcionResponse)response.getKey();
    }

    public EmpresaArchivoSubidoDescargaResponse generarTokenParaBajarArchivo(String archivoId) throws RestConnectorException {
        String subconvenio = "1";
        String path = "/cobro/archivo/devolucion/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/" + archivoId + "/ch/PT";
        Pair response = this.restConnector.genericGetWithResponseHeader(null, EmpresaArchivoSubidoDescargaResponse.class, ErrorResponse.class, path, null);
        this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)response.getValue()));
        return (EmpresaArchivoSubidoDescargaResponse)response.getKey();
    }

    public String bajarArchivo(String fileDownloadToken) throws RestConnectorException {
        String path = "/archivo?token=" + fileDownloadToken;
        Pair response = this.restConnector.genericGetWithResponseHeader(null, String.class, ErrorResponse.class, path, null);
        this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)response.getValue()));
        return (String)response.getKey();
    }

    public EmpresaCobroChequesDetalleResponse consultarPosicionIntegralDeCobrosCheques(Date fechaRecaudacionDesde, Date fechaRecaudacionHasta, Date fechaAcreditacionDesde, Date fechaAcreditacionHasta, String nroRecaudacion, int pagCant, int pagAct) throws RestConnectorException {
        String url = "/cobro/cheques/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + this.convenio + "/1/ch/PT";
        url = url + "?pag-cant=" + pagCant;
        url = url + "&pag-act=" + pagAct;
        if (fechaRecaudacionDesde != null) {
            url = url + "&fch-rec-dsd=" + this.sdf.format(fechaRecaudacionDesde);
        }
        if (fechaRecaudacionHasta != null) {
            url = url + "&fch-rec-hst=" + this.sdf.format(fechaRecaudacionHasta);
        }
        if (fechaAcreditacionDesde != null) {
            url = url + "&fch-acre-dsd=" + this.sdf.format(fechaAcreditacionDesde);
        }
        if (fechaAcreditacionHasta != null) {
            url = url + "&fch-acre-hst=" + this.sdf.format(fechaAcreditacionHasta);
        }
        if (StringUtils.isNotEmpty((CharSequence)nroRecaudacion)) {
            url = url + "&nro-recaudacion=" + nroRecaudacion;
        }
        Pair response = this.restConnector.genericGetWithResponseHeader(null, EmpresaCobroChequesDetalleResponse.class, ErrorResponse.class, url, null);
        this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)response.getValue()));
        return (EmpresaCobroChequesDetalleResponse)response.getKey();
    }
}

