package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.patagoniaapi.io.*;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.core.MultivaluedMap;
import java.util.Date;

@SuppressWarnings("unused")
public class PatagoniaApiCobrosConnector extends PatagoniaApiConnectorBase {

    private final static Logger log = LogManager.getLogger(PatagoniaApiCobrosConnector.class);

    public PatagoniaApiCobrosConnector(PatagoniaApiConnectorContext context) {
        super(context);
    }

    public EmpresaArchivoEstadoResponse publicarDeuda(String fileName, String fileInBase64) throws RestConnectorException {
        return uploadFile(fileName, fileInBase64);
    }

    @Override
    public EmpresaArchivoEstadoResponse confirmarOperacion(String token, String fileName) throws RestConnectorException {
        log.debug("[confirmarOperacion] Por confirmar procesamiento del archivo " + fileName);
        final String tipoArchivo = fileName.substring(0, 2);
        EmpresaCobroArchivoEstadoRequest empresaCobroArchivoEstadoRequest = new EmpresaCobroArchivoEstadoRequest();
        empresaCobroArchivoEstadoRequest.setToken(token);

        final String subconvenio = "1";
        final String path = "/cobro/archivo/prod/" + docProd + "/adherentes/" + adherente + "/" + convenio + "/" + subconvenio + "/estado/tipo-arch/" + tipoArchivo + "/doc-tp/" + documentoTipo + "/docNum/" + documentoNumero + "/ch/" + channel;
        EmpresaArchivoEstadoResponse response = restConnector.genericPost(empresaCobroArchivoEstadoRequest, EmpresaArchivoEstadoResponse.class, ErrorResponse.class, path);
        // Le setteo el token de subida de archivo para usarlo del lado de ebf en el creationSource
        response.getArchivo().setUploadToken(token);
        return response;
    }

    public void consultaConvenioPorAdherente() {
        // 5 - Metodo no implementado - ver documentacion - No nos aporta nada
    }

    public EmpresaCobroListadoResponse consultarPosicionIntegralDeCobros(Date fromDate, Date toDate) throws RestConnectorException {
        char urlParamsSep = '?';
        String url = "/cobro/prod/" + docProd + "/adherentes/" + adherente + "/" + convenio + "/1/ch/" + channel;

        if (fromDate != null) {
            url += urlParamsSep + "fch-rec-dsd=" + sdf.format(fromDate);
            urlParamsSep = '&';
        }
        if (toDate != null) {
            url += urlParamsSep + "fch-rec-hst=" + sdf.format(toDate);
            urlParamsSep = '&';
        }
        Pair<EmpresaCobroListadoResponse, MultivaluedMap<String,Object>> response = restConnector.genericGetWithResponseHeader(null, EmpresaCobroListadoResponse.class, ErrorResponse.class, url, null);
        generateAccessTokenFromResponseHeader(response.getValue());
        return response.getKey();
    }

    /**
     * @param pagCant Cantidad de elementos por pagina del paginador
     * @param pagAct  Numero de pagina del paginador
     */
    public EmpresaCobroDetalleResponse consultarDetallePosicionIntegralDeCobros(String subconvenio, String numeroCanal, String numeroConsulta, Date fechaRecuperoDesde, Date fechaRecuperoHasta, String deudor1, String deudor2,
                                                                                String comprobante1, String comprobante2, String comprobante3, String comprobante4, String comprobante5, int pagCant, int pagAct) throws RestConnectorException{
        String url = "/cobro/prod/" + docProd + "/adherentes/"  + adherente + "/" + convenio + "/"  + subconvenio + "/canal/" + numeroCanal + "/consulta/" + numeroConsulta;
        url += "?pag-cant=" + pagCant;
        url += "&pag-act=" + pagAct;

        if (fechaRecuperoDesde != null) {
            url += "&fch-rec-dsd=" + sdf.format(fechaRecuperoDesde);
        }
        if (fechaRecuperoHasta != null) {
            url += "&fch-rec-hst=" + sdf.format(fechaRecuperoHasta);
        }
        if (StringUtils.isNotEmpty(deudor1)) {
            url += "&deudor1=" + deudor1;
        }
        if (StringUtils.isNotEmpty(deudor2)) {
            url += "&deudor2=" + deudor2;
        }
        if (StringUtils.isNotEmpty(comprobante1)) {
            url += "&comprobante1=" + comprobante1;
        }
        if (StringUtils.isNotEmpty(comprobante2)) {
            url += "&comprobante2=" + comprobante2;
        }
        if (StringUtils.isNotEmpty(comprobante3)) {
            url += "&comprobante3=" + comprobante3;
        }
        if (StringUtils.isNotEmpty(comprobante4)) {
            url += "&comprobante4=" + comprobante4;
        }
        if (StringUtils.isNotEmpty(comprobante5)) {
            url += "&comprobante5=" + comprobante5;
        }
        return restConnector.genericGet(null, EmpresaCobroDetalleResponse.class, ErrorResponse.class, url);
    }

    public void historialPublicacionDeArchivos() {
        // 8 - Metodo no implementado - ver documentacion - No nos aporta nada
    }

    public ConsultaArchivosRecepcionResponse consultaArchivosRecepcion(Date fechaDesde, Date fechaHasta, int pagCant, int pagAct) throws RestConnectorException {
        final String subconvenio = "1";
        String path = "/cobro/archivo/devolucion/prod/" + docProd + "/adherentes/"  + adherente + "/" + convenio + "/"  + subconvenio + "/ch/" + channel;
        path += "?pag-cant=" + pagCant;
        path += "&pag-act=" + pagAct;

        if (fechaDesde != null) {
            path += "&fecha-dsd=" + sdf.format(fechaDesde);
        }
        if (fechaHasta != null) {
            path += "&fecha-hst=" + sdf.format(fechaHasta);
        }
        Pair<ConsultaArchivosRecepcionResponse, MultivaluedMap<String,Object>> response = restConnector.genericGetWithResponseHeader(null, ConsultaArchivosRecepcionResponse.class, ErrorResponse.class, path, null);
        generateAccessTokenFromResponseHeader(response.getValue());
        return response.getKey();
    }

    public EmpresaArchivoSubidoDescargaResponse generarTokenParaBajarArchivo(String archivoId) throws RestConnectorException {
        final String subconvenio = "1";
        final String path = "/cobro/archivo/devolucion/prod/" + docProd + "/adherentes/"  + adherente + "/" + convenio + "/"  + subconvenio + "/" + archivoId + "/ch/" + channel;
        Pair<EmpresaArchivoSubidoDescargaResponse, MultivaluedMap<String,Object>> response = restConnector.genericGetWithResponseHeader(null, EmpresaArchivoSubidoDescargaResponse.class, ErrorResponse.class, path, null);
        generateAccessTokenFromResponseHeader(response.getValue());
        return response.getKey();
    }

    public String bajarArchivo(String fileDownloadToken) throws RestConnectorException {
        final String path = "/archivo?token=" + fileDownloadToken;
        Pair<String, MultivaluedMap<String,Object>> response = restConnector.genericGetWithResponseHeader(null, String.class, ErrorResponse.class, path, null);
        generateAccessTokenFromResponseHeader(response.getValue());
        return response.getKey();
    }

    public EmpresaCobroChequesDetalleResponse consultarPosicionIntegralDeCobrosCheques(Date fechaRecaudacionDesde, Date fechaRecaudacionHasta,
                                                                                       Date fechaAcreditacionDesde, Date fechaAcreditacionHasta,
                                                                                       String nroRecaudacion,
                                                                                       int pagCant, int pagAct) throws RestConnectorException {
        String url = "/cobro/cheques/prod/" + docProd + "/adherentes/" + adherente + "/" + convenio + "/1/ch/" + channel;
        url += "?pag-cant=" + pagCant;
        url += "&pag-act=" + pagAct;

        if (fechaRecaudacionDesde != null) {
            url += "&fch-rec-dsd=" + sdf.format(fechaRecaudacionDesde);
        }

        if (fechaRecaudacionHasta != null) {
            url += "&fch-rec-hst=" + sdf.format(fechaRecaudacionHasta);
        }

        if (fechaAcreditacionDesde != null) {
            url += "&fch-acre-dsd=" + sdf.format(fechaAcreditacionDesde);
        }

        if (fechaAcreditacionHasta != null) {
            url += "&fch-acre-hst=" + sdf.format(fechaAcreditacionHasta);
        }

        if (StringUtils.isNotEmpty(nroRecaudacion)) {
            url += "&nro-recaudacion=" + nroRecaudacion;
        }

        Pair<EmpresaCobroChequesDetalleResponse, MultivaluedMap<String,Object>> response = restConnector.genericGetWithResponseHeader(null, EmpresaCobroChequesDetalleResponse.class, ErrorResponse.class, url, null);
        generateAccessTokenFromResponseHeader(response.getValue());
        return response.getKey();
    }
}