package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.ArchivoPagos;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaArchivosDevolucionResponse extends CommonResponse implements Serializable {

    @JsonProperty("archivoLista")
    private List<ArchivoPagos> archivos;

    public List<ArchivoPagos> getArchivos() {
        return archivos;
    }

    public void setArchivos(List<ArchivoPagos> archivos) {
        this.archivos = archivos;
    }

    @Override
    public String toString() {
        return "EmpresaArchivosDevolucionResponse [" +
                ((archivos != null) ? "archivos=" + Arrays.toString(archivos.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaArchivosDevolucionResponse that = (EmpresaArchivosDevolucionResponse) o;
        return Objects.equals(archivos, that.archivos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), archivos);
    }
}