package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ArchivoPago implements Serializable {

    @JsonProperty("ingresante")
    private Ingresante ingresante;

    @JsonProperty("cantidadRegistros")
    private Integer cantidadRegistros;

    @JsonProperty("estado")
    private Estado estado;

    @JsonProperty("id")
    private String id;

    @JsonProperty("importeTotal")
    private BigDecimal importeTotal;

    @JsonProperty("nombreArchivo")
    private NombreArchivo nombreArchivo;

    @JsonProperty("tipoArchivo")
    private TipoArchivo tipoArchivo;

    public Ingresante getIngresante() {
        return ingresante;
    }

    public void setIngresante(Ingresante ingresante) {
        this.ingresante = ingresante;
    }

    public Integer getCantidadRegistros() {
        return cantidadRegistros;
    }

    public void setCantidadRegistros(Integer cantidadRegistros) {
        this.cantidadRegistros = cantidadRegistros;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BigDecimal getImporteTotal() {
        return importeTotal;
    }

    public void setImporteTotal(BigDecimal importeTotal) {
        this.importeTotal = importeTotal;
    }

    public NombreArchivo getNombreArchivo() {
        return nombreArchivo;
    }

    public void setNombreArchivo(NombreArchivo nombreArchivo) {
        this.nombreArchivo = nombreArchivo;
    }

    public TipoArchivo getTipoArchivo() {
        return tipoArchivo;
    }

    public void setTipoArchivo(TipoArchivo tipoArchivo) {
        this.tipoArchivo = tipoArchivo;
    }

    @Override
    public String toString() {
        return "ArchivoPago [" +
                ((ingresante != null) ? "ingresante=" + ingresante + ", " : "") +
                ((cantidadRegistros != null) ? "cantidadRegistros=" + cantidadRegistros + ", " : "") +
                ((estado != null) ? "estado=" + estado + ", " : "") +
                ((id != null) ? "id='" + id + "', " : "") +
                ((importeTotal != null) ? "importeTotal=" + importeTotal + ", " : "") +
                ((nombreArchivo != null) ? "nombreArchivo=" + nombreArchivo + ", " : "") +
                ((tipoArchivo != null) ? "tipoArchivo=" + tipoArchivo + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ArchivoPago that = (ArchivoPago) o;
        return Objects.equals(ingresante, that.ingresante) && Objects.equals(cantidadRegistros, that.cantidadRegistros) && Objects.equals(estado, that.estado) && Objects.equals(id, that.id) && Objects.equals(importeTotal, that.importeTotal) && Objects.equals(nombreArchivo, that.nombreArchivo) && Objects.equals(tipoArchivo, that.tipoArchivo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ingresante, cantidadRegistros, estado, id, importeTotal, nombreArchivo, tipoArchivo);
    }
}