package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ArchivoPagos implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("estado")
    private Estado estado;

    @JsonProperty("fechaGeneracion")
    @JsonDeserialize(using = FechaGeneracionDeserializer.class)
    private Date fechaGeneracion;

    @JsonProperty("tipoArchivo")
    private TipoArchivo tipoArchivo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Date getFechaGeneracion() {
        return fechaGeneracion;
    }

    public void setFechaGeneracion(Date fechaGeneracion) {
        this.fechaGeneracion = fechaGeneracion;
    }

    public TipoArchivo getTipoArchivo() {
        return tipoArchivo;
    }

    public void setTipoArchivo(TipoArchivo tipoArchivo) {
        this.tipoArchivo = tipoArchivo;
    }

    @Override
    public String toString() {
        return "ArchivoPagos [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((estado != null) ? "estado=" + estado + ", " : "") +
                ((fechaGeneracion != null) ? "fechaGeneracion=" + fechaGeneracion + ", " : "") +
                ((tipoArchivo != null) ? "tipoArchivo=" + tipoArchivo + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ArchivoPagos archivo = (ArchivoPagos) o;
        return Objects.equals(id, archivo.id) && Objects.equals(estado, archivo.estado) && Objects.equals(fechaGeneracion, archivo.fechaGeneracion) && Objects.equals(tipoArchivo, archivo.tipoArchivo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, estado, fechaGeneracion, tipoArchivo);
    }

    // En la la llamada de ConsultaArchivosRecepcion nos mandan solamente la fecha, pero en otras llamadas nos mandan fecha y hora
    // Con esto soporto los 2 modelos sin necesidad de crear un clase nueva
    public static class FechaGeneracionDeserializer extends JsonDeserializer<Date> {

        private static final SimpleDateFormat FULL_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSSZZZZ");
        private static final SimpleDateFormat DATE_ONLY_FORMAT = new SimpleDateFormat("yyyyMMdd");

        @Override
        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String date = p.getText();

            try {
                // Intenta el formato completo con hora
                return FULL_FORMAT.parse(date);
            } catch (ParseException e) {
                // Si falla, intenta solo con la fecha
                try {
                    return DATE_ONLY_FORMAT.parse(date);
                } catch (ParseException ex) {
                    throw new RuntimeException("Error al parsear la fecha: " + date, ex);
                }
            }
        }
    }
}