package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OrdenPago implements Serializable {

    @JsonProperty("id")
    private Long id;

    @JsonProperty("fechaEjecucion")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMddHHmmssSSSZZZZ", timezone = "GMT-03:00")
    private Date fechaEjecucion;

    @JsonProperty("clienteReferencia")
    private String clienteReferencia;

    @JsonProperty("beneficiario")
    private Beneficiario beneficiario;

    @JsonProperty("importe")
    private BigDecimal importe;

    @JsonProperty("medioPago")
    private MedioPago medioPago;

    @JsonProperty("instrumentoPago")
    private InstrumentoPago instrumentoPago;

    @JsonProperty("chequeFechaVencimiento")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMddHHmmssSSSZZZZ", timezone = "GMT-03:00")
    private Date chequeFechaVencimiento;

    @JsonProperty("estado")
    private Estado estado;

    @JsonProperty("motivoRechazoEjecucion")
    private String motivoRechazoEjecucion;

    @JsonProperty("sucursalDestino")
    private SucursalDestino sucursalDestino;

    @JsonProperty("sucursal")
    private String sucursal;

    @JsonProperty("moneda")
    private Moneda moneda;

    @JsonProperty("operacion")
    private String operacion;

    @JsonProperty("cliente")
    private String cliente;

    @JsonProperty("comprobanteLista")
    private List<ComprobanteWrapper> comprobantes;

    @JsonProperty("cuenta")
    private Cuenta cuenta;

    @JsonProperty("formaPago")
    private String formaPago;

    @JsonProperty("motivoPago")
    private String motivoPago;

    @JsonProperty("CBU")
    private String cbu;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getFechaEjecucion() {
        return fechaEjecucion;
    }

    public void setFechaEjecucion(Date fechaEjecucion) {
        this.fechaEjecucion = fechaEjecucion;
    }

    public String getClienteReferencia() {
        return clienteReferencia;
    }

    public void setClienteReferencia(String clienteReferencia) {
        this.clienteReferencia = clienteReferencia;
    }

    public Beneficiario getBeneficiario() {
        return beneficiario;
    }

    public void setBeneficiario(Beneficiario beneficiario) {
        this.beneficiario = beneficiario;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public MedioPago getMedioPago() {
        return medioPago;
    }

    public void setMedioPago(MedioPago medioPago) {
        this.medioPago = medioPago;
    }

    public InstrumentoPago getInstrumentoPago() {
        return instrumentoPago;
    }

    public void setInstrumentoPago(InstrumentoPago instrumentoPago) {
        this.instrumentoPago = instrumentoPago;
    }

    public Date getChequeFechaVencimiento() {
        return chequeFechaVencimiento;
    }

    public void setChequeFechaVencimiento(Date chequeFechaVencimiento) {
        this.chequeFechaVencimiento = chequeFechaVencimiento;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public String getMotivoRechazoEjecucion() {
        return motivoRechazoEjecucion;
    }

    public void setMotivoRechazoEjecucion(String motivoRechazoEjecucion) {
        this.motivoRechazoEjecucion = motivoRechazoEjecucion;
    }

    public SucursalDestino getSucursalDestino() {
        return sucursalDestino;
    }

    public void setSucursalDestino(SucursalDestino sucursalDestino) {
        this.sucursalDestino = sucursalDestino;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(Moneda moneda) {
        this.moneda = moneda;
    }

    public String getOperacion() {
        return operacion;
    }

    public void setOperacion(String operacion) {
        this.operacion = operacion;
    }

    public String getCliente() {
        return cliente;
    }

    public void setCliente(String cliente) {
        this.cliente = cliente;
    }

    public List<ComprobanteWrapper> getComprobantes() {
        return comprobantes;
    }

    public void setComprobantes(List<ComprobanteWrapper> comprobantes) {
        this.comprobantes = comprobantes;
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public String getFormaPago() {
        return formaPago;
    }

    public void setFormaPago(String formaPago) {
        this.formaPago = formaPago;
    }

    public String getMotivoPago() {
        return motivoPago;
    }

    public void setMotivoPago(String motivoPago) {
        this.motivoPago = motivoPago;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    @Override
    public String toString() {
        return "OrdenPago [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((fechaEjecucion != null) ? "fechaEjecucion=" + fechaEjecucion + ", " : "") +
                ((clienteReferencia != null) ? "clienteReferencia='" + clienteReferencia + "', " : "") +
                ((beneficiario != null) ? "beneficiario=" + beneficiario + ", " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((medioPago != null) ? "medioPago=" + medioPago + ", " : "") +
                ((instrumentoPago != null) ? "instrumentoPago=" + instrumentoPago + ", " : "") +
                ((chequeFechaVencimiento != null) ? "chequeFechaVencimiento=" + chequeFechaVencimiento + ", " : "") +
                ((estado != null) ? "estado=" + estado + ", " : "") +
                ((motivoRechazoEjecucion != null) ? "motivoRechazoEjecucion='" + motivoRechazoEjecucion + "', " : "") +
                ((sucursalDestino != null) ? "sucursalDestino=" + sucursalDestino + ", " : "") +
                ((sucursal != null) ? "sucursal='" + sucursal + "', " : "") +
                ((moneda != null) ? "moneda=" + moneda + ", " : "") +
                ((operacion != null) ? "operacion='" + operacion + "', " : "") +
                ((cliente != null) ? "cliente='" + cliente + "', " : "") +
                ((comprobantes != null) ? "comprobantes=" + Arrays.toString(comprobantes.toArray()) + ", " : "") +
                ((cuenta != null) ? "cuenta=" + cuenta + ", " : "") +
                ((formaPago != null) ? "formaPago='" + formaPago + "', " : "") +
                ((motivoPago != null) ? "motivoPago='" + motivoPago + "', " : "") +
                ((cbu != null) ? "cbu='" + cbu + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrdenPago ordenPago = (OrdenPago) o;
        return Objects.equals(id, ordenPago.id) && Objects.equals(fechaEjecucion, ordenPago.fechaEjecucion) && Objects.equals(clienteReferencia, ordenPago.clienteReferencia) && Objects.equals(beneficiario, ordenPago.beneficiario) && Objects.equals(importe, ordenPago.importe) && Objects.equals(medioPago, ordenPago.medioPago) && Objects.equals(instrumentoPago, ordenPago.instrumentoPago) && Objects.equals(chequeFechaVencimiento, ordenPago.chequeFechaVencimiento) && Objects.equals(estado, ordenPago.estado) && Objects.equals(motivoRechazoEjecucion, ordenPago.motivoRechazoEjecucion) && Objects.equals(sucursalDestino, ordenPago.sucursalDestino) && Objects.equals(sucursal, ordenPago.sucursal) && Objects.equals(moneda, ordenPago.moneda) && Objects.equals(operacion, ordenPago.operacion) && Objects.equals(cliente, ordenPago.cliente) && Objects.equals(comprobantes, ordenPago.comprobantes) && Objects.equals(cuenta, ordenPago.cuenta) && Objects.equals(formaPago, ordenPago.formaPago) && Objects.equals(motivoPago, ordenPago.motivoPago) && Objects.equals(cbu, ordenPago.cbu);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, fechaEjecucion, clienteReferencia, beneficiario, importe, medioPago, instrumentoPago, chequeFechaVencimiento, estado, motivoRechazoEjecucion, sucursalDestino, sucursal, moneda, operacion, cliente, comprobantes, cuenta, formaPago, motivoPago, cbu);
    }
}