package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.Cuenta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaCuentasResponse extends CommonResponse implements Serializable {

    @JsonProperty("cuentaDefault")
    private Cuenta cuentaDefault;

    @JsonProperty("cuentaLista")
    private List<Cuenta> cuentas;

    public Cuenta getCuentaDefault() {
        return cuentaDefault;
    }

    public void setCuentaDefault(Cuenta cuentaDefault) {
        this.cuentaDefault = cuentaDefault;
    }

    public List<Cuenta> getCuentas() {
        return cuentas;
    }

    public void setCuentas(List<Cuenta> cuentas) {
        this.cuentas = cuentas;
    }

    @Override
    public String toString() {
        return "EmpresaCuentasResponse [" +
                ((cuentaDefault != null) ? "cuentaDefault=" + cuentaDefault + ", " : "") +
                ((cuentas != null) ? "cuentas=" + Arrays.toString(cuentas.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaCuentasResponse that = (EmpresaCuentasResponse) o;
        return Objects.equals(cuentaDefault, that.cuentaDefault) && Objects.equals(cuentas, that.cuentas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), cuentaDefault, cuentas);
    }
}