package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cheque implements Serializable {

    @JsonProperty("id")
    private Long id;

    @JsonProperty("numero")
    private String numero;

    @JsonProperty("estado")
    private String estadoId;

    @JsonProperty("estado")
    private Estado estado;

    @JsonProperty("beneficiario")
    private Beneficiario beneficiario;

    @JsonProperty("banco")
    private String banco;

    @JsonProperty("codigoPostal")
    private String codigoPostal;

    @JsonProperty("importe")
    private BigDecimal importe;

    @JsonProperty("cuenta")
    private String cuentaId;

    @JsonProperty("cuenta")
    private Cuenta cuenta;

    @JsonProperty("fechaRecaudacion")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaRecaudacion;

    @JsonProperty("sucursal")
    private String sucursal;

    @JsonProperty("moneda")
    private String moneda;

    @JsonProperty("nroRecaudacion")
    private String nroRecaudacion;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaAcreditacion;

    @JsonProperty("cantidadSinImprimir")
    private Long cantidadSinImprimir;

    @JsonProperty("cantidadTotal")
    private Long cantidadTotal;

    public String getNumero() {
        return numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getEstadoId() {
        return estadoId;
    }

    public void setEstado(String estadoId) {
        this.estadoId = estadoId;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getCodigoPostal() {
        return codigoPostal;
    }

    public void setCodigoPostal(String codigoPostal) {
        this.codigoPostal = codigoPostal;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getCuentaId() {
        return cuentaId;
    }

    public void setCuentaId(String cuentaId) {
        this.cuentaId = cuentaId;
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public Date getFechaRecaudacion() {
        return fechaRecaudacion;
    }

    public void setFechaRecaudacion(Date fechaRecaudacion) {
        this.fechaRecaudacion = fechaRecaudacion;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public String getNroRecaudacion() {
        return nroRecaudacion;
    }

    public void setNroRecaudacion(String nroRecaudacion) {
        this.nroRecaudacion = nroRecaudacion;
    }

    public Date getFechaAcreditacion() {
        return fechaAcreditacion;
    }

    public void setFechaAcreditacion(Date fechaAcreditacion) {
        this.fechaAcreditacion = fechaAcreditacion;
    }

    public Long getCantidadSinImprimir() {
        return cantidadSinImprimir;
    }

    public void setCantidadSinImprimir(Long cantidadSinImprimir) {
        this.cantidadSinImprimir = cantidadSinImprimir;
    }

    public Long getCantidadTotal() {
        return cantidadTotal;
    }

    public void setCantidadTotal(Long cantidadTotal) {
        this.cantidadTotal = cantidadTotal;
    }

    @Override
    public String toString() {
        return "Cheque [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((numero != null) ? "numero='" + numero + "', " : "") +
                ((estadoId != null) ? "estadoId='" + estadoId + "', " : "") +
                ((estado != null) ? "estado=" + estado + ", " : "") +
                ((beneficiario != null) ? "beneficiario=" + beneficiario + ", " : "") +
                ((banco != null) ? "banco='" + banco + "', " : "") +
                ((codigoPostal != null) ? "codigoPostal='" + codigoPostal + "', " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((cuentaId != null) ? "cuentaId='" + cuentaId + "', " : "") +
                ((cuenta != null) ? "cuenta=" + cuenta + ", " : "") +
                ((fechaRecaudacion != null) ? "fechaRecaudacion=" + fechaRecaudacion + ", " : "") +
                ((sucursal != null) ? "sucursal='" + sucursal + "', " : "") +
                ((moneda != null) ? "moneda='" + moneda + "', " : "") +
                ((nroRecaudacion != null) ? "nroRecaudacion='" + nroRecaudacion + "', " : "") +
                ((fechaAcreditacion != null) ? "fechaAcreditacion=" + fechaAcreditacion + ", " : "") +
                ((cantidadSinImprimir != null) ? "cantidadSinImprimir=" + cantidadSinImprimir + ", " : "") +
                ((cantidadTotal != null) ? "cantidadTotal=" + cantidadTotal + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cheque cheque = (Cheque) o;
        return Objects.equals(id, cheque.id) && Objects.equals(numero, cheque.numero) && Objects.equals(estadoId, cheque.estadoId) && Objects.equals(estado, cheque.estado) && Objects.equals(beneficiario, cheque.beneficiario) && Objects.equals(banco, cheque.banco) && Objects.equals(codigoPostal, cheque.codigoPostal) && Objects.equals(importe, cheque.importe) && Objects.equals(cuentaId, cheque.cuentaId) && Objects.equals(cuenta, cheque.cuenta) && Objects.equals(fechaRecaudacion, cheque.fechaRecaudacion) && Objects.equals(sucursal, cheque.sucursal) && Objects.equals(moneda, cheque.moneda) && Objects.equals(nroRecaudacion, cheque.nroRecaudacion) && Objects.equals(fechaAcreditacion, cheque.fechaAcreditacion) && Objects.equals(cantidadSinImprimir, cheque.cantidadSinImprimir) && Objects.equals(cantidadTotal, cheque.cantidadTotal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, numero, estadoId, estado, beneficiario, banco, codigoPostal, importe, cuentaId, cuenta, fechaRecaudacion, sucursal, moneda, nroRecaudacion, fechaAcreditacion, cantidadSinImprimir, cantidadTotal);
    }
}