package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cuenta implements Serializable {

    @JsonProperty("modulo")
    private Modulo modulo;

    @JsonProperty("moneda")
    private Moneda moneda;

    @JsonProperty("sucursal")
    private String sucursal;

    @JsonProperty("operacion")
    private String operacion;

    @JsonProperty("subOperacion")
    private String subOperacion;

    @JsonProperty("cliente")
    private String cliente;

    public Modulo getModulo() {
        return modulo;
    }

    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    public Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(Moneda moneda) {
        this.moneda = moneda;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getOperacion() {
        return operacion;
    }

    public void setOperacion(String operacion) {
        this.operacion = operacion;
    }

    public String getSubOperacion() {
        return subOperacion;
    }

    public void setSubOperacion(String subOperacion) {
        this.subOperacion = subOperacion;
    }

    public String getCliente() {
        return cliente;
    }

    public void setCliente(String cliente) {
        this.cliente = cliente;
    }

    @Override
    public String toString() {
        return "Cuenta [" +
                ((modulo != null) ? "modulo=" + modulo + ", " : "") +
                ((moneda != null) ? "moneda=" + moneda + ", " : "") +
                ((sucursal != null) ? "sucursal='" + sucursal + "', " : "") +
                ((operacion != null) ? "operacion='" + operacion + "', " : "") +
                ((subOperacion != null) ? "subOperacion='" + subOperacion + "', " : "") +
                ((cliente != null) ? "cliente='" + cliente + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cuenta cuenta = (Cuenta) o;
        return Objects.equals(modulo, cuenta.modulo) && Objects.equals(moneda, cuenta.moneda) && Objects.equals(sucursal, cuenta.sucursal) && Objects.equals(operacion, cuenta.operacion) && Objects.equals(subOperacion, cuenta.subOperacion) && Objects.equals(cliente, cuenta.cliente);
    }

    @Override
    public int hashCode() {
        return Objects.hash(modulo, moneda, sucursal, operacion, subOperacion, cliente);
    }
}