package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ListaCobros implements Serializable {

    @JsonProperty("convenioId")
    private String convenioId;

    @JsonProperty("subconvenioId")
    private String subconvenioId;

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("importe")
    private String importe;

    @JsonProperty("moneda")
    private Moneda moneda;

    public String getConvenioId() {
        return convenioId;
    }

    public void setConvenioId(String convenioId) {
        this.convenioId = convenioId;
    }

    public String getSubconvenioId() {
        return subconvenioId;
    }

    public void setSubconvenioId(String subconvenioId) {
        this.subconvenioId = subconvenioId;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(Moneda moneda) {
        this.moneda = moneda;
    }

    @Override
    public String toString() {
        return "Cobro{" +
                "convenioId='" + convenioId + '\'' +
                ", subconvenioId='" + subconvenioId + '\'' +
                ", descripcion='" + descripcion + '\'' +
                ", importe='" + importe + '\'' +
                ", moneda=" + moneda +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ListaCobros listaCobros = (ListaCobros) o;
        return Objects.equals(convenioId, listaCobros.convenioId) && Objects.equals(subconvenioId, listaCobros.subconvenioId) && Objects.equals(descripcion, listaCobros.descripcion) && Objects.equals(importe, listaCobros.importe) && Objects.equals(moneda, listaCobros.moneda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(convenioId, subconvenioId, descripcion, importe, moneda);
    }
}