/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoByIdResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoErroresResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoEstadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenResponse;
import ar.com.sdd.patagoniaapi.io.LoginRequest;
import ar.com.sdd.patagoniaapi.io.LoginResponse;
import ar.com.sdd.patagoniaapi.model.Documento;
import ar.com.sdd.patagoniaapi.model.Empresa;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import ar.com.sdd.patagoniaapi.model.Respuesta;
import ar.com.sdd.patagoniaapi.model.Token;
import ar.com.sdd.patagoniaapi.model.Usuario;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PatagoniaApiConnectorBase
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(PatagoniaApiConnectorBase.class);
    protected final RestConnector restConnector;
    protected final String xApplicationId;
    protected final String usuarioAlias;
    protected final String documentoTipo;
    protected final String documentoNumero;
    protected final String adherente;
    protected final String convenio;
    protected final String docProd;
    protected static final String channel = "PT";
    private boolean doingLogin;
    private String accessToken;
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ERROR = "ERROR";
    protected final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public PatagoniaApiConnectorBase(PatagoniaApiConnectorContext context) {
        this.usuarioAlias = context.getUsuarioAlias();
        this.documentoTipo = context.getDocumentoTipo();
        this.documentoNumero = context.getDocumentoNumero();
        this.xApplicationId = context.getXApplicationKey();
        this.adherente = context.getAdherente();
        this.convenio = context.getConvenio();
        this.docProd = context.getDocProd();
        log.debug("Creando PatagoniaApiConnector con " + context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public EmpresaArchivoEstadoResponse uploadFile(String fileName, String fileInBase64) throws RestConnectorException {
        log.debug("[uploadFile] Por hacer upload del archivo " + fileName);
        LoginResponse loginResponse = this.generateAccessToken();
        String userId = this.getUserId(loginResponse.getUsuario().getUriOperador());
        String uploadToken = this.generateUploadToken();
        EmpresaArchivoRequest empresaArchivoRequest = new EmpresaArchivoRequest();
        empresaArchivoRequest.setToken(uploadToken);
        empresaArchivoRequest.setUserId(userId);
        empresaArchivoRequest.setFileName(fileName);
        empresaArchivoRequest.setFile(fileInBase64);
        String path = "/archivo";
        EmpresaArchivoResponse empresaArchivoResponse = (EmpresaArchivoResponse)this.restConnector.genericPost((Object)empresaArchivoRequest, EmpresaArchivoResponse.class, "/archivo", "application/json", "application/x-www-form-urlencoded");
        if (empresaArchivoResponse == null) {
            throw new RuntimeException("[uploadFile] El response de la subida del archivo " + fileName + " fue null");
        }
        if (empresaArchivoResponse.getRespuesta() == null) {
            throw new RuntimeException("[uploadFile] No se pudo obtener el parametro [respuesta] del response");
        }
        Respuesta respuesta = empresaArchivoResponse.getRespuesta();
        if (respuesta.getCodigo().equals(STATUS_OK)) {
            return this.confirmarOperacion(empresaArchivoRequest.getToken(), fileName);
        }
        return null;
    }

    private String getUserId(String uriOperador) {
        String uriSFB = uriOperador.split(";")[1];
        Optional<String> userId = Arrays.stream(uriSFB.split("#")).filter(s -> s.startsWith("B2B")).findFirst();
        if (userId.isEmpty()) {
            throw new RuntimeException("No se pudo obtener el userId del LoginResponse.Usuario.UriOperador [" + uriOperador + "]");
        }
        return userId.get();
    }

    public abstract EmpresaArchivoEstadoResponse confirmarOperacion(String var1, String var2) throws RestConnectorException;

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-application-key", (Object)this.xApplicationId);
            if (!this.doingLogin) {
                builder.header("Authorization", (Object)("Bearer " + this.accessToken));
            }
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public LoginResponse generateAccessToken() throws RestConnectorException {
        Usuario usuario = new Usuario();
        usuario.setAlias(this.usuarioAlias);
        Documento documento = new Documento();
        documento.setTipo(this.documentoTipo);
        documento.setNumero(this.documentoNumero);
        Empresa empresa = new Empresa();
        empresa.setDocumento(documento);
        LoginRequest request = new LoginRequest();
        request.setUsuario(usuario);
        request.setEmpresa(empresa);
        log.debug("[generateAccessToken] Por hacer login y obtener token con " + request);
        this.doingLogin = true;
        String path = "/v2/login/ch/PT";
        Pair responsePair = this.restConnector.genericPostWithResponseHeader((Object)request, LoginResponse.class, "/v2/login/ch/PT");
        MultivaluedMap headers = (MultivaluedMap)responsePair.getValue();
        String xUid = null;
        List xUidList = (List)headers.get((Object)"x-uid");
        if (xUidList != null && !xUidList.isEmpty()) {
            xUid = (String)xUidList.get(0);
        }
        if (xUid == null || xUid.trim().isEmpty()) {
            throw new RuntimeException("[generateAccessToken] No se pudo obtener el parametro [x-uid] del response header");
        }
        String xAccessToken = null;
        List xAccessTokenList = (List)headers.get((Object)"x-access-token");
        if (xAccessTokenList != null && !xAccessTokenList.isEmpty()) {
            xAccessToken = (String)xAccessTokenList.get(0);
        }
        if (xAccessToken == null || xAccessToken.trim().isEmpty()) {
            throw new RuntimeException("[generateAccessToken] No se pudo obtener el parametro [x-access-token] del response header");
        }
        this.accessToken = Base64.getEncoder().encodeToString((xUid + ":" + xAccessToken).getBytes(StandardCharsets.UTF_8));
        log.debug("[generateAccessToken] Token recuperado y codificado a base64 [" + this.accessToken + "]");
        this.doingLogin = false;
        return (LoginResponse)responsePair.getKey();
    }

    public String generateUploadToken() throws RestConnectorException {
        log.debug("[generateUploadToken] Por obtener el token para subir el archivo");
        String path = "/archivo/token/sistema/CASH/accion/SUBIR/ch/PT";
        EmpresaArchivoTokenResponse empresaArchivoTokenResponse = (EmpresaArchivoTokenResponse)this.restConnector.genericPost((Object)new EmpresaArchivoTokenRequest(), EmpresaArchivoTokenResponse.class, "/archivo/token/sistema/CASH/accion/SUBIR/ch/PT");
        String uploadToken = null;
        List<Token> tokens = empresaArchivoTokenResponse.getToken();
        if (tokens != null && !tokens.isEmpty()) {
            uploadToken = tokens.get(0).getToken();
        }
        if (uploadToken == null || uploadToken.trim().isEmpty()) {
            throw new RuntimeException("[generateUploadToken] No se pudo obtener el parametro [tokenLista.token] del response");
        }
        log.debug("[generateUploadToken] Token para subir el archivo recuperado [" + uploadToken + "]");
        return uploadToken;
    }

    public EmpresaArchivoByIdResponse consultaEstadoArchivo(String archivoId) throws RestConnectorException {
        this.generateAccessToken();
        String path = "/archivo/estado/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + archivoId + "/ch/PT";
        return (EmpresaArchivoByIdResponse)this.restConnector.genericGet(null, EmpresaArchivoByIdResponse.class, ErrorResponse.class, path);
    }

    public EmpresaArchivoErroresResponse consultaErroresArchivo(String archivoId, Integer pagAct, Integer pagCant) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/prod/" + this.docProd + "/adherentes/" + this.adherente + "/pagos/errores-en-archivo/" + archivoId + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        return (EmpresaArchivoErroresResponse)this.restConnector.genericGet(null, EmpresaArchivoErroresResponse.class, ErrorResponse.class, path);
    }
}

