package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Referencia implements Serializable {

    @JsonProperty("deudor1")
    private String deudor1;

    @JsonProperty("deudor2")
    private String deudor2;

    @JsonProperty("comprobante1")
    private String comprobante1;

    @JsonProperty("comprobante2")
    private String comprobante2;

    @JsonProperty("comprobante3")
    private String comprobante3;

    @JsonProperty("comprobante4")
    private String comprobante4;

    @JsonProperty("comprobante5")
    private String comprobante5;

    public String getDeudor1() {
        return deudor1;
    }

    public void setDeudor1(String deudor1) {
        this.deudor1 = deudor1;
    }

    public String getDeudor2() {
        return deudor2;
    }

    public void setDeudor2(String deudor2) {
        this.deudor2 = deudor2;
    }

    public String getComprobante1() {
        return comprobante1;
    }

    public void setComprobante1(String comprobante1) {
        this.comprobante1 = comprobante1;
    }

    public String getComprobante2() {
        return comprobante2;
    }

    public void setComprobante2(String comprobante2) {
        this.comprobante2 = comprobante2;
    }

    public String getComprobante3() {
        return comprobante3;
    }

    public void setComprobante3(String comprobante3) {
        this.comprobante3 = comprobante3;
    }

    public String getComprobante4() {
        return comprobante4;
    }

    public void setComprobante4(String comprobante4) {
        this.comprobante4 = comprobante4;
    }

    public String getComprobante5() {
        return comprobante5;
    }

    public void setComprobante5(String comprobante5) {
        this.comprobante5 = comprobante5;
    }

    @Override
    public String toString() {
        return "Referencia [" +
                ((deudor1 != null) ? "deudor1='" + deudor1 + "', " : "") +
                ((deudor2 != null) ? "deudor2='" + deudor2 + "', " : "") +
                ((comprobante1 != null) ? "comprobante1='" + comprobante1 + "', " : "") +
                ((comprobante2 != null) ? "comprobante2='" + comprobante2 + "', " : "") +
                ((comprobante3 != null) ? "comprobante3='" + comprobante3 + "', " : "") +
                ((comprobante4 != null) ? "comprobante4='" + comprobante4 + "', " : "") +
                ((comprobante5 != null) ? "comprobante5='" + comprobante5 + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Referencia that = (Referencia) o;
        return Objects.equals(deudor1, that.deudor1) && Objects.equals(deudor2, that.deudor2) && Objects.equals(comprobante1, that.comprobante1) && Objects.equals(comprobante2, that.comprobante2) && Objects.equals(comprobante3, that.comprobante3) && Objects.equals(comprobante4, that.comprobante4) && Objects.equals(comprobante5, that.comprobante5);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deudor1, deudor2, comprobante1, comprobante2, comprobante3, comprobante4, comprobante5);
    }
}