package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.ArchivoSubido;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaArchivoEstadoResponse extends CommonResponse implements Serializable {

    @JsonProperty("archivo")
    private ArchivoSubido archivo;

    public ArchivoSubido getArchivo() {
        return archivo;
    }

    public void setArchivo(ArchivoSubido archivo) {
        this.archivo = archivo;
    }

    @Override
    public String toString() {
        return "EmpresaArchivoEstadoResponse [" +
                ((archivo != null) ? "archivo=" + archivo + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmpresaArchivoEstadoResponse that = (EmpresaArchivoEstadoResponse) o;
        return Objects.equals(archivo, that.archivo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(archivo);
    }
}