package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.HistorialEstado;
import ar.com.sdd.patagoniaapi.model.OrdenPago;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaPagoDetalleResponse extends CommonResponse implements Serializable {

    @JsonProperty("ordenPago")
    private OrdenPago ordenPago;

    @JsonProperty("historialEstadoLista")
    private List<HistorialEstado> historialEstados;

    public OrdenPago getOrdenPago() {
        return ordenPago;
    }

    public void setOrdenPago(OrdenPago ordenPago) {
        this.ordenPago = ordenPago;
    }

    public List<HistorialEstado> getHistorialEstados() {
        return historialEstados;
    }

    public void setHistorialEstados(List<HistorialEstado> historialEstados) {
        this.historialEstados = historialEstados;
    }

    @Override
    public String toString() {
        return "EmpresaPagoDetalleResponse [" +
                ((ordenPago != null) ? "ordenPago=" + ordenPago + ", " : "") +
                ((historialEstados != null) ? "historialEstados=" + Arrays.toString(historialEstados.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaPagoDetalleResponse that = (EmpresaPagoDetalleResponse) o;
        return Objects.equals(ordenPago, that.ordenPago) && Objects.equals(historialEstados, that.historialEstados);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), ordenPago, historialEstados);
    }
}