package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.OrdenPago;
import ar.com.sdd.patagoniaapi.model.OrdenPagoTotalizer;
import ar.com.sdd.patagoniaapi.model.Pagina;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaPagoListadoResponse extends CommonResponse implements Serializable {

    @JsonProperty("pagina")
    private Pagina pagina;

    @JsonProperty("ordenPago")
    private OrdenPagoTotalizer ordenPagoTotalizer;

    @JsonProperty("ordenPagoLista")
    private List<OrdenPago> ordenesDePago;

    public Pagina getPagina() {
        return pagina;
    }

    public void setPagina(Pagina pagina) {
        this.pagina = pagina;
    }

    public OrdenPagoTotalizer getOrdenPagoTotalizer() {
        return ordenPagoTotalizer;
    }

    public void setOrdenPagoTotalizer(OrdenPagoTotalizer ordenPagoTotalizer) {
        this.ordenPagoTotalizer = ordenPagoTotalizer;
    }

    public List<OrdenPago> getOrdenesDePago() {
        return ordenesDePago;
    }

    public void setOrdenesDePago(List<OrdenPago> ordenesDePago) {
        this.ordenesDePago = ordenesDePago;
    }

    @Override
    public String toString() {
        return "EmpresaPagoListadoResponse [" +
                ((pagina != null) ? "pagina=" + pagina + ", " : "") +
                ((ordenPagoTotalizer != null) ? "ordenPagoTotalizer=" + ordenPagoTotalizer + ", " : "") +
                ((ordenesDePago != null) ? "ordenesDePago=" + Arrays.toString(ordenesDePago.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaPagoListadoResponse that = (EmpresaPagoListadoResponse) o;
        return Objects.equals(pagina, that.pagina) && Objects.equals(ordenPagoTotalizer, that.ordenPagoTotalizer) && Objects.equals(ordenesDePago, that.ordenesDePago);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), pagina, ordenPagoTotalizer, ordenesDePago);
    }
}