package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaPagosHistoricosResponse extends CommonResponse implements Serializable {

    @JsonProperty("pagina")
    private Pagina pagina;

    @JsonProperty("archivoPagoLista")
    private List<ArchivoPago> archivoPagos;

    @JsonProperty("firmanteLista")
    private List<Firmante> firmantes;

    @JsonProperty("egresoLista")
    private List<Egreso> egresos;

    @JsonProperty("egresoChequeLista")
    private List<Egreso> egresosCheques;

    public Pagina getPagina() {
        return pagina;
    }

    public void setPagina(Pagina pagina) {
        this.pagina = pagina;
    }

    public List<ArchivoPago> getArchivoPagos() {
        return archivoPagos;
    }

    public void setArchivoPagos(List<ArchivoPago> archivoPagos) {
        this.archivoPagos = archivoPagos;
    }

    public List<Firmante> getFirmantes() {
        return firmantes;
    }

    public void setFirmantes(List<Firmante> firmantes) {
        this.firmantes = firmantes;
    }

    public List<Egreso> getEgresos() {
        return egresos;
    }

    public void setEgresos(List<Egreso> egresos) {
        this.egresos = egresos;
    }

    public List<Egreso> getEgresosCheques() {
        return egresosCheques;
    }

    public void setEgresosCheques(List<Egreso> egresosCheques) {
        this.egresosCheques = egresosCheques;
    }

    @Override
    public String toString() {
        return "EmpresaPagosHistoricosResponse [" +
                ((pagina != null) ? "pagina=" + pagina + ", " : "") +
                ((archivoPagos != null) ? "archivoPagos=" + Arrays.toString(archivoPagos.toArray()) + ", " : "") +
                ((firmantes != null) ? "firmantes=" + Arrays.toString(firmantes.toArray()) + ", " : "") +
                ((egresos != null) ? "egresos=" + Arrays.toString(egresos.toArray()) + ", " : "") +
                ((egresosCheques != null) ? "egresosCheques=" + Arrays.toString(egresosCheques.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaPagosHistoricosResponse that = (EmpresaPagosHistoricosResponse) o;
        return Objects.equals(pagina, that.pagina) && Objects.equals(archivoPagos, that.archivoPagos) && Objects.equals(firmantes, that.firmantes) && Objects.equals(egresos, that.egresos) && Objects.equals(egresosCheques, that.egresosCheques);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), pagina, archivoPagos, firmantes, egresos, egresosCheques);
    }
}