package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ArchivoEstado implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("idEstado")
    private String idEstado;

    @JsonProperty("estado")
    private String estado;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdEstado() {
        return idEstado;
    }

    public void setIdEstado(String idEstado) {
        this.idEstado = idEstado;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    @Override
    public String toString() {
        return "Archivo [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((idEstado != null) ? "idEstado='" + idEstado + "', " : "") +
                ((estado != null) ? "estado='" + estado + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ArchivoEstado archivo = (ArchivoEstado) o;
        return Objects.equals(id, archivo.id) && Objects.equals(idEstado, archivo.idEstado) && Objects.equals(estado, archivo.estado);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, idEstado, estado);
    }
}