package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OrdenPagoTotalizer implements Serializable {

    @JsonProperty("cantidad")
    private Integer cantidad;

    @JsonProperty("importeTotal")
    private BigDecimal importeTotal;

    public Integer getCantidad() {
        return cantidad;
    }

    public void setCantidad(Integer cantidad) {
        this.cantidad = cantidad;
    }

    public BigDecimal getImporteTotal() {
        return importeTotal;
    }

    public void setImporteTotal(BigDecimal importeTotal) {
        this.importeTotal = importeTotal;
    }

    @Override
    public String toString() {
        return "OrdenPagoTotalizer [" +
                ((cantidad != null) ? "cantidad=" + cantidad + ", " : "") +
                ((importeTotal != null) ? "importeTotal=" + importeTotal + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrdenPagoTotalizer that = (OrdenPagoTotalizer) o;
        return Objects.equals(cantidad, that.cantidad) && Objects.equals(importeTotal, that.importeTotal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cantidad, importeTotal);
    }
}